/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.component;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sensinact.gateway.app.manager.json.AppCondition;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;

public class DataProviderSubscription {
    private final String dataProviderUri;
    private final Set<AppCondition> conditions;
    private final List<List<String>> routes;

    public DataProviderSubscription(String dataProviderUri, Set<AppCondition> conditions, List<List<String>> routes) {
        this.dataProviderUri = dataProviderUri;
        this.conditions = conditions;
        this.routes = routes;
    }

    public String getDataProviderUri() {
        return this.dataProviderUri;
    }

    public String getApplicationName() {
        return this.dataProviderUri.split("/")[1];
    }

    public String getComponentName() {
        return this.dataProviderUri.split("/")[2];
    }

    public String getOutputName() {
        return this.dataProviderUri.split("/")[3];
    }

    public Set<Constraint> getConstraints() {
        if (this.conditions.isEmpty()) {
            return null;
        }
        HashSet<Constraint> constraints = new HashSet<Constraint>();
        for (AppCondition condition : this.conditions) {
            constraints.add(condition.getConstraint());
        }
        return constraints;
    }

    public List<List<String>> getRoutes() {
        return this.routes;
    }
}

