/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.sensinact.gateway.app.api.exception.ApplicationFactoryException;
import org.eclipse.sensinact.gateway.app.api.exception.InvalidApplicationException;
import org.eclipse.sensinact.gateway.app.api.lifecycle.ApplicationStatus;
import org.eclipse.sensinact.gateway.app.api.persistence.ApplicationPersistenceService;
import org.eclipse.sensinact.gateway.app.api.persistence.dao.Application;
import org.eclipse.sensinact.gateway.app.api.persistence.listener.ApplicationAvailabilityListenerAbstract;
import org.eclipse.sensinact.gateway.app.api.plugin.PluginInstaller;
import org.eclipse.sensinact.gateway.app.manager.application.ApplicationService;
import org.eclipse.sensinact.gateway.app.manager.application.dependency.DependencyManager;
import org.eclipse.sensinact.gateway.app.manager.application.dependency.DependencyManagerCallback;
import org.eclipse.sensinact.gateway.app.manager.checker.ArchitectureChecker;
import org.eclipse.sensinact.gateway.app.manager.component.Component;
import org.eclipse.sensinact.gateway.app.manager.component.ResourceDataProvider;
import org.eclipse.sensinact.gateway.app.manager.factory.ApplicationFactory;
import org.eclipse.sensinact.gateway.app.manager.json.AppContainer;
import org.eclipse.sensinact.gateway.app.manager.json.AppParameter;
import org.eclipse.sensinact.gateway.app.manager.osgi.AppServiceMediator;
import org.eclipse.sensinact.gateway.app.manager.osgi.PluginsProxy;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.core.Attribute;
import org.eclipse.sensinact.gateway.core.InvalidResourceException;
import org.eclipse.sensinact.gateway.core.InvalidServiceException;
import org.eclipse.sensinact.gateway.core.ServiceProviderImpl;
import org.eclipse.sensinact.gateway.core.method.AccessMethodExecutor;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponseBuilder;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppInstallExecutor
extends ApplicationAvailabilityListenerAbstract
implements AccessMethodExecutor {
    private static Logger LOG = LoggerFactory.getLogger(AppInstallExecutor.class);
    private final AppServiceMediator mediator;
    private final ServiceProviderImpl device;
    private final ApplicationPersistenceService persistenceService;
    private Boolean persist = false;

    AppInstallExecutor(AppServiceMediator mediator, ServiceProviderImpl device, ApplicationPersistenceService persistenceService) {
        this.mediator = mediator;
        this.device = device;
        this.persistenceService = persistenceService;
    }

    public Void execute(AccessMethodResponseBuilder jsonObjects) throws Exception {
        String name = (String)jsonObjects.getParameter(0);
        JSONObject content = (JSONObject)jsonObjects.getParameter(1);
        if (this.persist.booleanValue()) {
            JSONObject httpJSONObject = new JSONObject();
            JSONArray parametersArray = new JSONArray();
            JSONObject appName = new JSONObject();
            appName.put("name", (Object)"name");
            appName.put("type", (Object)"string");
            appName.put("value", (Object)name);
            JSONObject appContent = new JSONObject();
            appContent.put("name", (Object)"content");
            appContent.put("type", (Object)"object");
            appContent.put("value", (Object)content);
            parametersArray.put((Object)appName);
            parametersArray.put((Object)appContent);
            httpJSONObject.put("parameters", (Object)parametersArray);
            this.persistenceService.persist(new Application(name, httpJSONObject));
        }
        jsonObjects.setAccessMethodObjectResult((Object)new JSONObject().put("message", (Object)("Application " + name + " successfully installed.")));
        return null;
    }

    public synchronized void install(final String name, JSONObject content) throws Exception {
        ServiceReference[] references;
        if (name == null) {
            throw new InvalidApplicationException("Unable to install the application: application 'name' is null");
        }
        if (content == null) {
            throw new InvalidApplicationException("Unable to install the application: application 'content' is null");
        }
        final AppContainer appContainer = new AppContainer(this.mediator, name, content);
        ArchitectureChecker.checkApplication(appContainer.getApplicationName(), appContainer.getComponents());
        if (this.device.getService(name) != null) {
            ApplicationService applicationService = (ApplicationService)this.device.getService(name);
            if (ApplicationStatus.ACTIVE.equals(applicationService.getResource("status").getAttribute("value").getValue())) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("The application " + name + " is active. Unable to update the application.");
                }
                throw new InvalidApplicationException("The application " + name + " is active. Unable to update the application.");
            }
            this.device.removeService(applicationService.getName());
        }
        if ((references = this.mediator.getContext().getServiceReferences(PluginInstaller.class.getCanonicalName(), "(objectClass=*)")) == null) {
            this.mediator.getContext().addServiceListener(new ServiceListener(){

                public void serviceChanged(ServiceEvent serviceEvent) {
                    AppInstallExecutor.this.startApplication(name, appContainer, AppInstallExecutor.this.mediator);
                }
            }, PluginsProxy.APP_INSTALL_HOOK_FILTER);
        } else {
            this.startApplication(name, appContainer, this.mediator);
        }
    }

    private void startApplication(String name, AppContainer appContainer, AppServiceMediator mediator) {
        try {
            final ApplicationService applicationService = (ApplicationService)this.device.addService(name);
            final org.eclipse.sensinact.gateway.app.manager.application.Application application = ApplicationFactory.createApplication(mediator, appContainer, applicationService);
            applicationService.createSnaService(appContainer, application);
            if (appContainer.getInitialize().getOptions().getAutoStart()) {
                LOG.warn("Application {} activated the SAR service", (Object)name);
                HashSet<ResourceDataProvider> dependenciesURI = new HashSet<ResourceDataProvider>(application.getResourceSubscriptions().keySet());
                ArrayList<String> dependenciesURIString = new ArrayList<String>();
                for (ResourceDataProvider resourceDataProvider : dependenciesURI) {
                    dependenciesURIString.add(resourceDataProvider.getUri());
                }
                for (Map.Entry entry : application.getComponents().entrySet()) {
                    for (AppParameter param : ((Component)entry.getValue()).getFunctionParameters()) {
                        if (!param.getType().equals("resource")) continue;
                        dependenciesURIString.add(param.getValue().toString());
                    }
                }
                DependencyManager dependencyManager = new DependencyManager(application, mediator, dependenciesURIString, new DependencyManagerCallback(){

                    @Override
                    public void ready(String applicationName) {
                        try {
                            LOG.info("Application {} is valid, resource all present", (Object)applicationName);
                            application.start();
                            Attribute attribute = applicationService.getResource("status").getAttribute("value");
                            attribute.setValue((Object)ApplicationStatus.ACTIVE);
                        }
                        catch (Exception e) {
                            LOG.warn("Failed to start application {}", (Object)applicationName, (Object)e);
                        }
                    }

                    @Override
                    public void unready(String applicationName) {
                        LOG.info("Application {} is NO longer valid, resource are missing", (Object)applicationName);
                        try {
                            Attribute attribute = applicationService.getResource("status").getAttribute("value");
                            attribute.setValue((Object)ApplicationStatus.INSTALLED);
                            application.stop();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                dependencyManager.start();
            } else {
                LOG.warn("Application {} did not activate SAR service", (Object)name);
            }
        }
        catch (ApplicationFactoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Unable to create the application " + name + " > " + e.getMessage());
            }
            this.device.removeService(name);
            e.printStackTrace();
        }
        catch (InvalidValueException | InvalidResourceException | InvalidServiceException e) {
            e.printStackTrace();
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Application " + name + " successfully installed.");
        }
    }

    @Override
    public void serviceOnline() {
        this.persist = true;
    }
}

