/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.internal;

import org.eclipse.sensinact.gateway.app.api.exception.InvalidApplicationException;
import org.eclipse.sensinact.gateway.app.api.persistence.ApplicationPersistenceService;
import org.eclipse.sensinact.gateway.app.api.persistence.exception.ApplicationPersistenceException;
import org.eclipse.sensinact.gateway.app.api.persistence.listener.ApplicationAvailabilityListenerAbstract;
import org.eclipse.sensinact.gateway.core.ServiceProviderImpl;
import org.eclipse.sensinact.gateway.core.method.AccessMethodExecutor;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponseBuilder;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppUninstallExecutor
extends ApplicationAvailabilityListenerAbstract
implements AccessMethodExecutor {
    private static Logger LOG = LoggerFactory.getLogger(AppUninstallExecutor.class);
    private final ServiceProviderImpl device;
    private final ApplicationPersistenceService persistenceService;

    AppUninstallExecutor(ServiceProviderImpl device, ApplicationPersistenceService persistenceService) {
        this.device = device;
        this.persistenceService = persistenceService;
    }

    public Void execute(AccessMethodResponseBuilder jsonObjects) {
        String name = (String)jsonObjects.getParameter(0);
        try {
            this.uninstall(name);
            jsonObjects.setAccessMethodObjectResult((Object)new JSONObject().put("message", (Object)("The application " + name + " has been uninstalled")));
        }
        catch (Exception e) {
            jsonObjects.setAccessMethodObjectResult((Object)new JSONObject().put("message", (Object)("The application " + name + " has failed to be uninstalled")));
        }
        return null;
    }

    public void uninstall(String name) throws InvalidApplicationException {
        if (name == null) {
            throw new InvalidApplicationException("Wrong parameters. Unable to uninstall the application");
        }
        try {
            this.persistenceService.delete(name);
        }
        catch (ApplicationPersistenceException e) {
            LOG.warn("Impossible to remove application '{}' from persistence system");
        }
    }
}

