/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.device.openhab.internal;

import java.text.ParseException;
import org.eclipse.sensinact.gateway.device.openhab.internal.OpenHabPacketReader;

enum OpenhabType {
    SwitchItem,
    Switch,
    String,
    NumberItem,
    Number,
    Number_Temperature{

        @Override
        protected Object parseValue(Object value) {
            Object parsedValue = null;
            if (value != null && !value.equals("NULL")) {
                try {
                    Object[] parsedArray = OpenHabPacketReader.TEMPERATURE_FORMAT.parse(value.toString());
                    parsedValue = parsedArray[0];
                }
                catch (ParseException ex) {
                    OpenHabPacketReader.LOG.error("unexpected format for {}: not a {} format?", value, (Object)this);
                }
            }
            return parsedValue;
        }
    }
    ,
    Player,
    Rollershutter,
    Dimmer,
    Contact,
    Color,
    DateTime,
    Group,
    Image,
    Location,
    Default;


    private static OpenhabType getType(String type$) {
        String openhabType$ = type$.replaceAll(":", "_");
        OpenhabType openhabType = null;
        try {
            openhabType = OpenhabType.valueOf(openhabType$);
        }
        catch (Exception e) {
            openhabType = Default;
            OpenHabPacketReader.LOG.error("unsupported openhab type {}. Using {}...", new Object[]{type$, openhabType, e});
        }
        return openhabType;
    }

    static Object parseValue(String type, Object value) {
        OpenhabType openhabType = OpenhabType.getType(type);
        return openhabType.parseValue(value);
    }

    protected Object parseValue(Object value) {
        return value;
    }
}

