/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.bundle;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.sensinact.gateway.common.bundle.ManagedConfigurationListener;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MediatorManagedConfiguration
implements ManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(MediatorManagedConfiguration.class);
    public static final String MANAGED_SENSINACT_MODULE = "org.eclipse.sensinact.gateway.managed";
    private Mediator mediator;
    private ServiceRegistration<ManagedService> registration;
    private List<ManagedConfigurationListener> listeners;
    private String pid;

    MediatorManagedConfiguration(Mediator mediator, String pid) {
        this.pid = pid;
        this.mediator = mediator;
        this.listeners = new ArrayList<ManagedConfigurationListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ManagedConfigurationListener listener) {
        if (listener != null) {
            List<ManagedConfigurationListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteListener(ManagedConfigurationListener listener) {
        if (listener != null) {
            List<ManagedConfigurationListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }

    private Dictionary<String, Object> getDefaults() {
        Hashtable<String, Object> defaults = new Hashtable<String, Object>();
        defaults.put("service.pid", this.pid);
        return defaults;
    }

    public void register() {
        this.registration = this.mediator.getContext().registerService(ManagedService.class, (Object)this, this.getDefaults());
    }

    public void unregister() {
        if (this.registration == null) {
            return;
        }
        try {
            this.registration.unregister();
        }
        catch (IllegalStateException e) {
            LOG.error(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (this.registration == null) {
            return;
        }
        Dictionary<String, Object> props = null;
        Dictionary<String, Object> dflt = this.getDefaults();
        if (properties == null) {
            props = dflt;
        } else {
            props = properties;
            Enumeration<String> e = dflt.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                if (props.get(key) != null) continue;
                props.put(key, dflt.get(key));
            }
        }
        List<ManagedConfigurationListener> list = this.listeners;
        synchronized (list) {
            try {
                this.registration.setProperties(props);
                for (ManagedConfigurationListener listener : this.listeners) {
                    listener.updated(props);
                }
            }
            catch (Exception e) {
                throw new ConfigurationException(null, e.getMessage(), (Throwable)e);
            }
        }
    }
}

