/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.rest.internal.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.method.Parameter;
import org.eclipse.sensinact.gateway.core.security.Authentication;
import org.eclipse.sensinact.gateway.core.security.Credentials;
import org.eclipse.sensinact.gateway.core.security.InvalidCredentialException;
import org.eclipse.sensinact.gateway.core.security.SessionToken;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRecipient;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequestWrapper;
import org.eclipse.sensinact.gateway.nthbnd.rest.internal.http.HttpRecipient;
import org.eclipse.sensinact.gateway.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRestAccessRequest
extends HttpServletRequestWrapper
implements NorthboundRequestWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRestAccessRequest.class);
    private NorthboundMediator mediator;
    private Map<NorthboundRequestWrapper.QueryKey, List<String>> queryMap;
    private Authentication<?> authentication;
    private String content;

    public HttpRestAccessRequest(NorthboundMediator mediator, HttpServletRequest request) throws InvalidCredentialException {
        super(request);
        this.mediator = mediator;
    }

    public NorthboundMediator getMediator() {
        return this.mediator;
    }

    public Map<NorthboundRequestWrapper.QueryKey, List<String>> getQueryMap() {
        if (this.queryMap == null) {
            try {
                this.queryMap = NorthboundRequest.processRequestQuery((String)super.getQueryString());
            }
            catch (UnsupportedEncodingException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.queryMap = Collections.emptyMap();
            }
        }
        return this.queryMap;
    }

    public String getContent() {
        if (this.content == null) {
            try {
                ServletInputStream input = super.getInputStream();
                byte[] stream = IOUtils.read((InputStream)input, (int)super.getContentLength(), (boolean)true);
                this.content = new String(stream);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.content;
    }

    void setAuthentication(Authentication<?> authentication) {
        this.authentication = authentication;
    }

    public Authentication<?> getAuthentication() {
        if (this.authentication == null) {
            String tokenHeader = super.getHeader("X-Auth-Token");
            String authorizationHeader = super.getHeader("Authorization");
            if (tokenHeader != null) {
                this.authentication = new SessionToken(tokenHeader);
            } else if (authorizationHeader != null && super.getAttribute("token") == null) {
                this.authentication = new Credentials(authorizationHeader);
            }
        }
        return this.authentication;
    }

    public String getRequestIdProperty() {
        return "rid";
    }

    public String getRequestId() {
        return super.getHeader(this.getRequestIdProperty());
    }

    public NorthboundRecipient createRecipient(List<Parameter> parameters) {
        HttpRecipient recipient = null;
        int length = parameters == null ? 0 : parameters.size();
        String callback = null;
        Object conditions = null;
        for (int index = 0; index < length; ++index) {
            String name = parameters.get(index).getName();
            if (!"callback".equals(name)) continue;
            callback = (String)parameters.get(index).getValue();
            break;
        }
        if (callback != null) {
            recipient = new HttpRecipient((Mediator)this.mediator, callback);
        }
        return recipient;
    }

    public void destroy() {
        this.queryMap = null;
        this.authentication = null;
        this.content = null;
    }
}

