/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.factory.endpoint;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketException;
import org.eclipse.sensinact.gateway.generic.packet.PayloadFragment;
import org.eclipse.sensinact.gateway.sthbnd.http.factory.endpoint.AbstractHttpDevicePacketReader;
import org.eclipse.sensinact.gateway.sthbnd.http.factory.endpoint.RootMappingTree;
import org.eclipse.sensinact.gateway.sthbnd.http.factory.packet.TaskAwareHttpResponsePacket;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.NestedMappingDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPacketReader
extends AbstractHttpDevicePacketReader
implements Iterator<PayloadFragment> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonPacketReader.class);
    private final LinkedList<Object> context = new LinkedList();
    private final MappingJsonFactory factory;
    private final Map<String, Map<String, String>> mappings = new HashMap<String, Map<String, String>>();
    private JsonParser parser;
    private RootMappingTree tree;

    public JsonPacketReader(SimpleDateFormat timestampFormat, String providerIdPattern, MappingJsonFactory factory) {
        super(timestampFormat, providerIdPattern);
        this.factory = factory;
    }

    public void load(TaskAwareHttpResponsePacket packet) throws InvalidPacketException {
        Arrays.stream(packet.getMapping()).forEach(m -> this.mappings.put(m.getMappingType() == 1 ? "" : ((NestedMappingDescription)m).getPath(), m.getMapping()));
        this.tree = new RootMappingTree(this.mappings.keySet());
        BufferedReader reader = null;
        try {
            JsonToken token;
            reader = packet.getReader();
            this.parser = this.factory.createParser((Reader)reader);
            while ((token = this.parser.nextToken()) != null && !token.isStructStart()) {
            }
            if (token == null) {
                this.safeClose((AutoCloseable)this.parser);
            }
        }
        catch (Exception e) {
            if (this.parser != null) {
                this.safeClose((AutoCloseable)this.parser);
            } else if (reader != null) {
                this.safeClose(reader);
            }
            LOG.error("Failed to load a JSON packet.", (Throwable)e);
            throw new InvalidPacketException("Failed to load JSON packet", (Throwable)e);
        }
    }

    public void parse() throws InvalidPacketException {
    }

    public void reset() {
        if (this.parser != null) {
            this.safeClose((AutoCloseable)this.parser);
        }
        this.context.clear();
        this.tree = null;
        this.mappings.clear();
    }

    @Override
    public boolean hasNext() {
        if (this.parser == null) {
            throw new IllegalStateException("This PacketReader is not initialized");
        }
        JsonToken currentToken = this.parser.currentToken();
        if (currentToken == null) {
            currentToken = JsonToken.NOT_AVAILABLE;
        }
        try {
            while (currentToken != null) {
                if (currentToken.isStructStart()) {
                    switch (this.tree.getAction(this.context)) {
                        case Ignore: {
                            this.parser.skipChildren();
                            this.updateContext(this.parser.currentToken());
                            break;
                        }
                        case Select: {
                            return true;
                        }
                    }
                }
                if ((currentToken = this.parser.nextToken()) == null) continue;
                this.updateContext(currentToken);
            }
        }
        catch (IOException e) {
            this.safeClose((AutoCloseable)this.parser);
            LOG.error("Failed to parse a JSON packet.", (Throwable)e);
            throw new IllegalArgumentException("Unable to read the complete packet", e);
        }
        this.safeClose((AutoCloseable)this.parser);
        return false;
    }

    private void updateContext(JsonToken state) throws IOException {
        String name = this.parser.currentName();
        Object last = this.context.peekLast();
        switch (state) {
            case START_OBJECT: {
                if (name != null) {
                    this.context.addLast(name);
                    break;
                }
                if (last instanceof Integer) {
                    this.context.removeLast();
                    this.context.addLast((Integer)last + 1);
                    break;
                }
                this.context.addLast(0);
                break;
            }
            case END_OBJECT: {
                if (!(last instanceof String)) break;
                this.context.removeLast();
                break;
            }
            case START_ARRAY: {
                if (name != null) {
                    this.context.addLast(name);
                    break;
                }
                if (last instanceof Integer) {
                    this.context.removeLast();
                    int update = (Integer)last + 1;
                    this.context.addLast("[" + update + "]");
                    break;
                }
                this.context.addLast("[0]");
                break;
            }
            case END_ARRAY: {
                if (last instanceof Integer) {
                    this.context.removeLast();
                }
                if (!((last = this.context.peekLast()) instanceof String)) break;
                this.context.removeLast();
                String s = (String)last;
                if (s.charAt(0) != '[') break;
                this.context.addLast(Integer.parseInt(s.substring(1, s.length() - 1)));
                break;
            }
        }
    }

    @Override
    public PayloadFragment next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements");
        }
        try {
            HashMap<String, Object> data;
            String matchedPath = this.tree.getMappedPath(this.context);
            JsonToken currentToken = this.parser.currentToken();
            if (currentToken == JsonToken.START_OBJECT) {
                data = (HashMap<String, Object>)this.parser.readValueAs((TypeReference)new TypeReference<Map<String, Object>>(){});
                this.updateContext(JsonToken.END_OBJECT);
            } else if (currentToken == JsonToken.START_ARRAY) {
                List list = (List)this.parser.readValueAs((TypeReference)new TypeReference<List<Object>>(){});
                data = new HashMap<String, Object>();
                for (int i = 0; i < list.size(); ++i) {
                    data.put(String.format("[" + i + "]", new Object[0]), list.get(i));
                }
                this.updateContext(JsonToken.END_ARRAY);
            } else {
                this.safeClose((AutoCloseable)this.parser);
                LOG.error("Failed to parse a JSON packet and ended up in an inconsistent state");
                throw new IllegalStateException("Failed to read the complete packet");
            }
            return this.createFragments(data, this.mappings.get(matchedPath));
        }
        catch (IOException e) {
            this.safeClose((AutoCloseable)this.parser);
            LOG.error("Failed to parse a JSON packet.", (Throwable)e);
            throw new IllegalArgumentException("Failed to read the complete packet", e);
        }
    }
}

