/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.device.openhab.common;

public class ServerLocation {
    private static final String DEFAULT_SCHEME = "http";
    private final String host;
    private final int port;
    private final String scheme;

    public ServerLocation(String host, int port) {
        this(DEFAULT_SCHEME, host, port);
    }

    public ServerLocation(String scheme, String host, int port) {
        this.host = host;
        this.port = port;
        this.scheme = scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getScheme() {
        if (this.scheme == null) {
            return DEFAULT_SCHEME;
        }
        return this.scheme;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerLocation other = (ServerLocation)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        return this.port == other.port;
    }

    public String toString() {
        return "OpenHabServer [host=" + this.host + ", port=" + this.port + "]";
    }
}

