/*
 * Decompiled with CFR 0.152.
 */
package org.sensinact.mqtt.server.internal;

import com.hazelcast.config.ClasspathXmlConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ITopic;
import io.moquette.interception.HazelcastInterceptHandler;
import io.moquette.interception.HazelcastMsg;
import io.moquette.interception.InterceptHandler;
import io.moquette.parser.proto.messages.PublishMessage;
import io.moquette.server.ServerAcceptor;
import io.moquette.server.config.IConfig;
import io.moquette.server.netty.SensinactNettyAcceptor;
import io.moquette.spi.impl.ProtocolProcessor;
import io.moquette.spi.impl.SensiNactProtocolProcessorBootstrapper;
import io.moquette.spi.impl.subscriptions.Subscription;
import io.moquette.spi.security.IAuthenticator;
import io.moquette.spi.security.IAuthorizator;
import io.moquette.spi.security.ISslContextCreator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.sensinact.mqtt.server.internal.HazelcastListener;
import org.sensinact.mqtt.server.internal.SensiNactDefaultMoquetteSslContextCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensiNactServer {
    private static final Logger LOG = LoggerFactory.getLogger(SensiNactServer.class);
    private static final String HZ_INTERCEPT_HANDLER = HazelcastInterceptHandler.class.getCanonicalName();
    private final BundleContext bundleContext;
    private ServerAcceptor m_acceptor;
    private volatile boolean m_initialized;
    private ProtocolProcessor m_processor;
    private HazelcastInstance hazelcastInstance;
    private SensiNactProtocolProcessorBootstrapper m_processorBootstrapper;

    public SensiNactServer(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer(IConfig config, List<? extends InterceptHandler> handlers, ISslContextCreator sslCtxCreator, IAuthenticator authenticator, IAuthorizator authorizator) throws IOException {
        String handlerProp;
        if (handlers == null) {
            handlers = Collections.emptyList();
        }
        if ((handlerProp = System.getProperty("intercept.handler")) != null) {
            config.setProperty("intercept.handler", handlerProp);
        }
        this.configureCluster(config);
        LOG.info("Persistent store file: {}", (Object)config.getProperty("persistent_store"));
        this.m_processorBootstrapper = new SensiNactProtocolProcessorBootstrapper(this.bundleContext);
        ProtocolProcessor processor = this.m_processorBootstrapper.init(config, handlers, authenticator, authorizator, this);
        if (sslCtxCreator == null) {
            sslCtxCreator = new SensiNactDefaultMoquetteSslContextCreator(config);
        }
        this.m_acceptor = new SensinactNettyAcceptor(this.bundleContext);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((BundleWiring)this.bundleContext.getBundle().adapt(BundleWiring.class)).getClassLoader());
            this.m_acceptor.initialize(processor, config, sslCtxCreator);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        this.m_processor = processor;
        this.m_initialized = true;
    }

    private void configureCluster(IConfig config) throws FileNotFoundException {
        String interceptHandlerClassname = config.getProperty("intercept.handler");
        if (interceptHandlerClassname == null || !HZ_INTERCEPT_HANDLER.equals(interceptHandlerClassname)) {
            return;
        }
        String hzConfigPath = config.getProperty("hazelcast.configuration");
        if (hzConfigPath != null) {
            boolean isHzConfigOnClasspath = this.getClass().getClassLoader().getResource(hzConfigPath) != null;
            Config hzconfig = isHzConfigOnClasspath ? new ClasspathXmlConfig(hzConfigPath) : new FileSystemXmlConfig(hzConfigPath);
            LOG.info(String.format("starting server with hazelcast configuration file : %s", hzconfig));
            this.hazelcastInstance = Hazelcast.newHazelcastInstance(hzconfig);
        } else {
            LOG.info("starting server with hazelcast default file");
            this.hazelcastInstance = Hazelcast.newHazelcastInstance();
        }
        HazelcastInstance hz = this.getHazelcastInstance();
        ITopic<HazelcastMsg> topic = hz.getTopic("moquette");
        topic.addMessageListener(new HazelcastListener(this));
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public void internalPublish(PublishMessage msg) {
        if (!this.m_initialized) {
            throw new IllegalStateException("Can't publish on a server is not yet started");
        }
        this.m_processor.internalPublish(msg);
    }

    public void stopServer() {
        LOG.info("Server stopping...");
        this.m_acceptor.close();
        this.m_processorBootstrapper.shutdown();
        this.m_initialized = false;
        if (this.hazelcastInstance != null) {
            try {
                this.hazelcastInstance.shutdown();
            }
            catch (HazelcastInstanceNotActiveException e) {
                LOG.info("hazelcast already shutdown");
            }
        }
        LOG.info("Server stopped");
    }

    public List<Subscription> getSubscriptions() {
        if (this.m_processorBootstrapper == null) {
            return null;
        }
        return this.m_processorBootstrapper.getSubscriptions();
    }

    public boolean addInterceptHandler(InterceptHandler interceptHandler) {
        if (!this.m_initialized) {
            throw new IllegalStateException("Can't register interceptors on a server that is not yet started");
        }
        return this.m_processor.addInterceptHandler(interceptHandler);
    }

    public boolean removeInterceptHandler(InterceptHandler interceptHandler) {
        if (!this.m_initialized) {
            throw new IllegalStateException("Can't deregister interceptors from a server that is not yet started");
        }
        return this.m_processor.removeInterceptHandler(interceptHandler);
    }
}

