/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.primitive.Nameable;
import org.eclipse.sensinact.gateway.generic.parser.DeviceDefinition;

public class FixedProviders
implements Iterable<FixedProvider> {
    final List<FixedProvider> providers;

    public FixedProviders(List<DeviceDefinition> providers) {
        ArrayList<FixedProvider> preProviders = new ArrayList<FixedProvider>();
        if (providers != null) {
            for (DeviceDefinition deviceDefinition : providers) {
                preProviders.add(new FixedProvider(deviceDefinition.getServiceProviderProfile(), deviceDefinition.getServiceProviderIdentifier(), deviceDefinition.getServices()));
            }
        }
        this.providers = Collections.unmodifiableList(preProviders);
    }

    @Override
    public Iterator<FixedProvider> iterator() {
        return this.providers.iterator();
    }

    public Map<String, List<String>> getFixedMap() {
        HashMap<String, List<String>> fixed = new HashMap<String, List<String>>();
        for (FixedProvider provider : this) {
            ArrayList<String> services = new ArrayList<String>();
            fixed.put(provider.getName(), services);
            Iterator<String> serviceIterator = provider.iterator();
            while (serviceIterator.hasNext()) {
                services.add(serviceIterator.next());
            }
        }
        return fixed;
    }

    public Map<String, String> getProviderMap() {
        HashMap<String, String> fixedProviders = new HashMap<String, String>();
        for (FixedProvider provider : this) {
            fixedProviders.put(provider.getName(), provider.getProfile());
        }
        return fixedProviders;
    }

    public final class FixedProvider
    implements Iterable<String>,
    Nameable {
        private final String[] services;
        private final String provider;
        private final String profile;

        FixedProvider(String profile, String provider, String[] services) {
            this.provider = provider;
            this.services = services;
            this.profile = profile;
        }

        public String getName() {
            return this.provider;
        }

        public String[] getServices() {
            if (this.services == null) {
                return new String[0];
            }
            String[] services = new String[this.services.length];
            System.arraycopy(this.services, 0, services, 0, this.services.length);
            return services;
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private int pos = 0;
                private final int length = FixedProvider.access$000(FixedProvider.this) == null ? 0 : FixedProvider.access$000(FixedProvider.this).length;

                @Override
                public boolean hasNext() {
                    return this.pos < this.length;
                }

                @Override
                public String next() {
                    return FixedProvider.this.services[this.pos++];
                }

                @Override
                public void remove() {
                }
            };
        }

        public String getProfile() {
            return this.profile;
        }
    }
}

