/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.mqtt.device;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.InvalidProtocolStackException;
import org.eclipse.sensinact.gateway.generic.local.LocalProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.device.MqttPacket;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.util.api.MqttBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttProtocolStackEndpoint
extends LocalProtocolStackEndpoint<MqttPacket> {
    private static final Logger LOG = LoggerFactory.getLogger(MqttProtocolStackEndpoint.class);
    private Map<String, MqttBroker> brokers = new HashMap<String, MqttBroker>();

    public MqttProtocolStackEndpoint(Mediator mediator) {
        super(mediator);
    }

    public void addBroker(MqttBroker broker) {
        this.brokers.put(broker.getClientId(), broker);
    }

    public void removeBroker(String clientId) {
        MqttBroker broker = this.brokers.remove(clientId);
        try {
            broker.disconnect();
        }
        catch (Exception e) {
            LOG.error("Unable to disconnect from MQTT broker: {}, {}", (Object)broker.getHost(), (Object)e);
        }
    }

    public void connectBrokers() {
        for (Map.Entry<String, MqttBroker> map : this.brokers.entrySet()) {
            try {
                map.getValue().connect();
            }
            catch (Exception e) {
                LOG.error("Unable to connect from MQTT broker: {}, {}", (Object)map.getValue().getHost(), (Object)e);
            }
        }
    }

    public void disconnectBrokers() {
        for (Map.Entry<String, MqttBroker> map : this.brokers.entrySet()) {
            try {
                map.getValue().disconnect();
            }
            catch (Exception e) {
                LOG.error("Unable to disconnect from MQTT broker: {}, {}", (Object)map.getValue().getHost(), (Object)e);
            }
        }
    }

    public Map<String, MqttBroker> getBrokers() {
        return this.brokers;
    }

    public void connect(ExtModelConfiguration<MqttPacket> manager) throws InvalidProtocolStackException {
        super.connect(manager);
        this.connectBrokers();
    }

    public void stop() {
        this.disconnectBrokers();
        super.stop();
    }
}

