/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.historic.storage.agent.generic;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessage;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessageImpl;
import org.eclipse.sensinact.gateway.core.message.whiteboard.AbstractAgentRelay;
import org.eclipse.sensinact.gateway.historic.storage.agent.generic.StorageConnection;
import org.eclipse.sensinact.gateway.historic.storage.agent.generic.StorageKeyProcessorProvider;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.json.JSONObject;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StorageAgent
extends AbstractAgentRelay {
    private static final Logger LOG = LoggerFactory.getLogger(StorageAgent.class);
    protected static final String STORAGE_AGENT_KEYS_PROPS = "org.eclipse.sensinact.gateway.history.keys";
    protected static final String STORAGE_KEY_PROCESSOR_PROVIDER = "sensinact.history.key.processor";
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    protected BundleContext bc;
    private Map<String, Executable<SnaMessage<?>, Object>> keyProcessors;
    private Map<String, Object> storageKeyValuesMap;
    private Map<String, String> storageKeyNamesMap;
    private Map<String, String> locations;
    private StorageConnection storageConnection;

    protected abstract String[] getKeyProcessorProviderIdentifiers();

    public StorageAgent(BundleContext bc) {
        this.bc = bc;
        this.locations = new HashMap<String, String>();
        this.storageKeyValuesMap = new HashMap<String, Object>();
        this.keyProcessors = new HashMap();
        this.keyProcessors.put("path", new Executable<SnaMessage<?>, Object>(){

            public Object execute(SnaMessage<?> message) throws Exception {
                String path = message.getPath();
                String[] pathElements = UriUtils.getUriElements((String)path);
                if (pathElements.length == 3) {
                    return path.concat("/value");
                }
                return path;
            }
        });
        this.keyProcessors.put("resource", new Executable<SnaMessage<?>, Object>(){

            public Object execute(SnaMessage<?> message) throws Exception {
                String path = message.getPath();
                String[] pathElements = UriUtils.getUriElements((String)path);
                if (pathElements.length > 2) {
                    return pathElements[2];
                }
                return null;
            }
        });
        this.keyProcessors.put("location", new Executable<SnaMessage<?>, Object>(){

            public Object execute(SnaMessage<?> message) throws Exception {
                String uri = message.getPath();
                String[] pathElements = UriUtils.getUriElements((String)uri);
                return StorageAgent.this.getLocation(pathElements[0]);
            }
        });
    }

    protected Map<String, Executable<SnaMessage<?>, Object>> loadRegisteredProcessors() {
        HashMap processors = new HashMap();
        processors.putAll(this.keyProcessors);
        String[] keyProcessorProviderIdentifiers = this.getKeyProcessorProviderIdentifiers();
        if (keyProcessorProviderIdentifiers != null && keyProcessorProviderIdentifiers.length > 0) {
            StringBuilder builder = Arrays.stream(keyProcessorProviderIdentifiers).collect(StringBuilder::new, (sb, s) -> {
                sb.append("(");
                sb.append(STORAGE_KEY_PROCESSOR_PROVIDER);
                sb.append("=");
                sb.append((String)s);
                sb.append(")");
            }, (sb1, sb2) -> sb1.append(sb2.toString()));
            if (keyProcessorProviderIdentifiers.length > 1) {
                builder.insert(0, "(|");
                builder.append(")");
            }
            String filter = builder.toString();
            try {
                Collection refs = this.bc.getServiceReferences(StorageKeyProcessorProvider.class, filter);
                processors.putAll(refs.stream().map(r -> (StorageKeyProcessorProvider)this.bc.getService(r)).collect(HashMap::new, (m, s) -> m.putAll(s.getStorageKeyProcessors()), Map::putAll));
                refs.stream().forEach(r -> this.bc.ungetService(r));
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return processors;
    }

    protected void setStorageKeys(String keys) {
        this.storageKeyNamesMap = keys != null ? (Map)Arrays.asList(keys.split(",")).stream().collect(HashMap::new, (h, prop) -> {
            String[] keyValuePair = prop.split("=");
            String key = keyValuePair[0].trim();
            if (UriUtils.getUriElements((String)key).length == 2) {
                key = key.concat("/value");
            }
            h.put(key, keyValuePair[1].trim());
        }, Map::putAll) : Collections.emptyMap();
    }

    public void addFixKeyProcessor(String key, Executable<SnaMessage<?>, Object> executor) {
        if (key != null && executor != null) {
            this.keyProcessors.put(key, executor);
        }
    }

    protected void setStorageConnection(StorageConnection storageConnection) {
        this.storageConnection = storageConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLocation(String serviceProvider) {
        Map<String, String> map = this.locations;
        synchronized (map) {
            return this.locations.get(serviceProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLocation(String serviceProvider, String location) {
        Map<String, String> map = this.locations;
        synchronized (map) {
            this.locations.put(serviceProvider, location);
        }
    }

    private Dictionary<String, Object> preProcessSnaMessage(SnaMessage<?> message) {
        Hashtable<String, Object> ts = new Hashtable<String, Object>();
        Map<String, Executable<SnaMessage<?>, Object>> processors = this.loadRegisteredProcessors();
        for (String key : processors.keySet()) {
            Object val = null;
            try {
                val = processors.get(key).execute(message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (val == null) continue;
            ((Dictionary)ts).put(key, val);
        }
        return ts;
    }

    public void doHandle(SnaUpdateMessageImpl message) {
        this.doHandle(message.getPath(), message.getNotification(), this.preProcessSnaMessage((SnaMessage<?>)message));
    }

    public void doHandle(SnaLifecycleMessageImpl message) {
        if (!SnaLifecycleMessage.Lifecycle.RESOURCE_APPEARING.equals((Object)message.getType()) || Resource.Type.ACTION.equals(message.getNotification(Resource.Type.class, "type"))) {
            return;
        }
        this.doHandle(message.getPath(), (JSONObject)message.get("initial"), this.preProcessSnaMessage((SnaMessage<?>)message));
    }

    private void doHandle(String path, JSONObject content, Dictionary<String, Object> ts) {
        Long timestamp;
        Object timestampProp;
        Object value = content.opt("value");
        if (content.has("value") && JSONObject.NULL.equals(value)) {
            return;
        }
        String[] pathElements = UriUtils.getUriElements((String)path);
        String provider = pathElements[0];
        String resource = pathElements[2];
        if ("location".equalsIgnoreCase(resource)) {
            this.setLocation(provider, String.valueOf(value));
            return;
        }
        if (this.storageConnection == null) {
            return;
        }
        String attribute = (String)content.opt("name");
        if (pathElements[2].equals(attribute)) {
            attribute = "value";
        }
        if (this.storageKeyNamesMap != null) {
            String serviceUri;
            Set<String> keys = this.storageKeyNamesMap.keySet();
            if (keys.contains(serviceUri = UriUtils.getUri((String[])new String[]{pathElements[1], pathElements[2], attribute}))) {
                this.storageKeyValuesMap.put(UriUtils.getUri((String[])new String[]{pathElements[0], pathElements[1], pathElements[2], attribute}), value);
                return;
            }
            String serviceProviderId = pathElements[0];
            keys.forEach(s -> {
                String p = UriUtils.getUri((String[])new String[]{serviceProviderId, s});
                Object tagValue = this.storageKeyValuesMap.get(p);
                if (tagValue != null) {
                    ts.put(this.storageKeyNamesMap.get(s), tagValue);
                }
            });
        }
        if ((timestampProp = content.opt("timestamp")) == null) {
            timestamp = System.currentTimeMillis();
        } else {
            try {
                timestamp = Long.valueOf(String.valueOf(timestampProp));
            }
            catch (NumberFormatException e) {
                timestamp = System.currentTimeMillis();
            }
        }
        String timestampStr = FORMAT.format(new Date(timestamp));
        JSONObject jsonObject = new JSONObject();
        Enumeration<String> it = ts.keys();
        while (it.hasMoreElements()) {
            String k = it.nextElement();
            jsonObject.put(k, ts.get(k));
        }
        jsonObject.put("value", value);
        jsonObject.put("timestamp", (Object)timestampStr);
        this.storageConnection.stack.push(jsonObject);
        LOG.debug("pushed to stack : {}/{}...", (Object)path, value);
    }

    public void stop() {
        if (this.storageConnection != null) {
            this.storageConnection.close();
        }
    }
}

