/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.agent.storage.http.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.historic.storage.agent.generic.StorageConnection;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfiguration;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfigurationImpl;
import org.eclipse.sensinact.gateway.protocol.http.client.Response;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleRequest;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpStorageConnection
extends StorageConnection {
    private static final Logger LOG = LoggerFactory.getLogger(HttpStorageConnection.class);
    protected String broker;
    protected String authorization;
    private String login;
    private String password;

    public HttpStorageConnection(String uri, String login, String password) throws IOException {
        this.login = login;
        this.password = password;
        this.broker = uri;
        this.authorization = Base64.getEncoder().encodeToString((this.login + ":" + this.password).getBytes());
    }

    protected void store(JSONObject object) {
        block5: {
            ConnectionConfigurationImpl configuration = new ConnectionConfigurationImpl();
            try {
                Iterator iterator;
                configuration.setContentType("application/json");
                configuration.setAccept("application/json");
                configuration.setUri(this.broker);
                configuration.setContent((Object)object.toString());
                configuration.setHttpMethod("POST");
                configuration.addHeader("Authorization", "Basic " + this.authorization);
                configuration.addHeader("User-Agent", "java/sensiNact-storage");
                SimpleRequest request = new SimpleRequest((ConnectionConfiguration)configuration);
                Response response = request.send();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" >> response status code: %s", (Object)response.getStatusCode());
                }
                if (!(iterator = response.getHeaders().entrySet().iterator()).hasNext()) {
                    return;
                }
                Map.Entry entry = iterator.next();
                while (iterator.hasNext()) {
                    LOG.debug((String)entry.getKey() + " :: " + (entry.getValue() == null ? "null" : Arrays.toString(((List)entry.getValue()).toArray(new String[0]))));
                    entry = iterator.next();
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

