/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.fusesource.hawtdispatch.Dispatcher;
import org.fusesource.hawtdispatch.Metrics;
import org.fusesource.hawtdispatch.internal.HawtDispatcher;
import org.fusesource.hawtdispatch.jmx.MBeanInfo;

public class JmxService {
    public static final String DISPATCHER_OBJECT_NAME = "org.hawtdispatch:type=Dispatcher";
    private static CompositeType METRICS_COMPOSITE_TYPE;

    public static CompositeData convert(Metrics metric, TimeUnit timeUnit) throws OpenDataException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("label", metric.queue.getLabel());
        fields.put("duration", (double)metric.durationNS / (double)timeUnit.toNanos(1L));
        fields.put("enqueued", metric.enqueued);
        fields.put("enqueueTimeMean", (double)metric.totalWaitTimeNS / (double)timeUnit.toNanos(1L) / (double)metric.dequeued);
        fields.put("enqueueTimeMax", (double)metric.maxWaitTimeNS / (double)timeUnit.toNanos(1L));
        fields.put("enqueueTimeTotal", (double)metric.totalWaitTimeNS / (double)timeUnit.toNanos(1L));
        fields.put("executed", metric.dequeued);
        fields.put("executeTimeMean", (double)metric.totalRunTimeNS / (double)timeUnit.toNanos(1L) / (double)metric.dequeued);
        fields.put("executeTimeMax", (double)metric.maxRunTimeNS / (double)timeUnit.toNanos(1L));
        fields.put("executeTimeTotal", (double)metric.totalRunTimeNS / (double)timeUnit.toNanos(1L));
        return new CompositeDataSupport(METRICS_COMPOSITE_TYPE, fields);
    }

    public static ObjectName objectName(HawtDispatcher dispatcher) {
        try {
            return new ObjectName("org.hawtdispatch:type=Dispatcher,name=" + ObjectName.quote(dispatcher.getLabel()));
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public static void register(HawtDispatcher dispatcher) throws Exception {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        server.registerMBean(new JmxDispatcher(dispatcher), JmxService.objectName(dispatcher));
    }

    public static void unregister(HawtDispatcher dispatcher) throws Exception {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        server.unregisterMBean(new ObjectName(DISPATCHER_OBJECT_NAME));
    }

    static {
        CompositeTypeFactory factory = new CompositeTypeFactory();
        factory.addItem("label", "The queue label", SimpleType.STRING);
        factory.addItem("duration", "The length of time spent gathering metricsN", SimpleType.DOUBLE);
        factory.addItem("enqueued", "The number of tasks enqueued", SimpleType.LONG);
        factory.addItem("enqueueTimeMean", "The mean amount of time an enqueued tasks waited before it was executed", SimpleType.DOUBLE);
        factory.addItem("enqueueTimeMax", "The maximum amount of time a single enqueued task waited before it was executed", SimpleType.DOUBLE);
        factory.addItem("enqueueTimeTotal", "The total amount of time all enqueued tasks spent waiting to be executed", SimpleType.DOUBLE);
        factory.addItem("executed", "The number of tasks executed", SimpleType.LONG);
        factory.addItem("executeTimeMean", "The mean amount of time tasks took to execute", SimpleType.DOUBLE);
        factory.addItem("executeTimeMax", "The maximum amount of time a single task took to execute", SimpleType.DOUBLE);
        factory.addItem("executeTimeTotal", "The total amount of time all tasks spent executing", SimpleType.DOUBLE);
        METRICS_COMPOSITE_TYPE = factory.create(Metrics.class);
    }

    static class CompositeTypeFactory {
        private final List<String> itemNamesList = new ArrayList<String>();
        private final List<String> itemDescriptionsList = new ArrayList<String>();
        private final List<OpenType> itemTypesList = new ArrayList<OpenType>();

        CompositeTypeFactory() {
        }

        protected void addItem(String name, String description, OpenType type) {
            this.itemNamesList.add(name);
            this.itemDescriptionsList.add(description);
            this.itemTypesList.add(type);
        }

        protected CompositeType create(Class clazz) {
            return this.create(clazz.getName(), clazz.getName());
        }

        protected CompositeType create(String name, String description) {
            try {
                String[] itemNames = this.itemNamesList.toArray(new String[this.itemNamesList.size()]);
                String[] itemDescriptions = this.itemDescriptionsList.toArray(new String[this.itemDescriptionsList.size()]);
                OpenType[] itemTypes = this.itemTypesList.toArray(new OpenType[this.itemTypesList.size()]);
                return new CompositeType(name, description, itemNames, itemDescriptions, itemTypes);
            }
            catch (OpenDataException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class JmxDispatcher
    implements JmxDispatcherMBean {
        final Dispatcher dispatcher;
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;

        public JmxDispatcher(Dispatcher dispatcher) {
            this.dispatcher = dispatcher;
        }

        public String getTimeUnit() {
            return this.timeUnit.name();
        }

        public void setTimeUnit(String unit) {
            this.timeUnit = TimeUnit.valueOf(unit);
        }

        public boolean getProfile() {
            return this.dispatcher.profile();
        }

        public void setProfile(boolean enabled) {
            this.dispatcher.profile(enabled);
        }

        public CompositeData[] getMetrics() throws OpenDataException {
            ArrayList<CompositeData> rc = new ArrayList<CompositeData>();
            ArrayList<Metrics> metrics = new ArrayList<Metrics>(this.dispatcher.metrics());
            Collections.sort(metrics, new Comparator<Metrics>(){

                @Override
                public int compare(Metrics l, Metrics r) {
                    if (l.totalRunTimeNS == r.totalRunTimeNS) {
                        return 0;
                    }
                    return l.totalRunTimeNS < r.totalRunTimeNS ? 1 : -1;
                }
            });
            for (Metrics metric : metrics) {
                rc.add(JmxService.convert(metric, this.timeUnit));
            }
            return rc.toArray(new CompositeData[rc.size()]);
        }
    }

    public static interface JmxDispatcherMBean {
        @MBeanInfo(value="Used to enable or disable profiling")
        public void setTimeUnit(String var1);

        @MBeanInfo(value="Is profiling enabled.")
        public String getTimeUnit();

        @MBeanInfo(value="Used to enable or disable profiling")
        public void setProfile(boolean var1);

        @MBeanInfo(value="Is profiling enabled.")
        public boolean getProfile();

        @MBeanInfo(value="Get the collected profiling metrics.")
        public CompositeData[] getMetrics() throws OpenDataException;
    }
}

