/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.framework.Bundle;

public abstract class ReflectUtils {
    private static final Logger LOGGER = Logger.getLogger(ReflectUtils.class.getCanonicalName());

    public static Method containsSignature(Method method, Collection<Method> methods) {
        if (methods == null || methods.isEmpty()) {
            return null;
        }
        for (Method containedMethod : methods) {
            if (!ReflectUtils.signatureEquals(method, containedMethod)) continue;
            return containedMethod;
        }
        return null;
    }

    public static boolean signatureEquals(Method first, Method second) {
        int index;
        Class<?>[] secondParameterTypes;
        if (first == null || second == null) {
            return false;
        }
        if (!first.getName().equals(second.getName())) {
            return false;
        }
        Class<?>[] firstParameterTypes = first.getParameterTypes();
        if (firstParameterTypes.length != (secondParameterTypes = second.getParameterTypes()).length) {
            return false;
        }
        for (index = 0; index < firstParameterTypes.length && firstParameterTypes[index] == secondParameterTypes[index]; ++index) {
        }
        return index == firstParameterTypes.length;
    }

    public static LinkedList<Class<?>> getOrderedImplementedInterfaces(Class<?> bottomClass) {
        LinkedList list = new LinkedList();
        if (bottomClass == null) {
            return list;
        }
        if (bottomClass.isInterface()) {
            list.offer(bottomClass);
        } else {
            list = ReflectUtils.getOrderedImplementedInterfaces(bottomClass.getSuperclass());
        }
        Class<?>[] interfaces = bottomClass.getInterfaces();
        if (interfaces != null) {
            for (int index = 0; index < interfaces.length; ++index) {
                LinkedList<Class<?>> inheritedList = ReflectUtils.getOrderedImplementedInterfaces(interfaces[index]);
                while (!inheritedList.isEmpty()) {
                    Class<?> inheritedClass = inheritedList.removeFirst();
                    if (list.contains(inheritedClass)) continue;
                    list.offer(inheritedClass);
                }
            }
        }
        return list;
    }

    public static <C> LinkedList<Class<C>> getOrderedImplementedInterfaces(Class<C> referenceInterface, Class<?> bottomClass) {
        LinkedList<Class<C>> list = new LinkedList<Class<C>>();
        if (referenceInterface == null || !referenceInterface.isInterface() || bottomClass == null || !referenceInterface.isAssignableFrom(bottomClass)) {
            return list;
        }
        if (bottomClass.isInterface()) {
            list.offer(bottomClass);
        } else {
            list = ReflectUtils.getOrderedImplementedInterfaces(referenceInterface, bottomClass.getSuperclass());
        }
        Class<?>[] interfaces = bottomClass.getInterfaces();
        if (interfaces != null) {
            for (int index = 0; index < interfaces.length; ++index) {
                if (!referenceInterface.isAssignableFrom(interfaces[index])) continue;
                LinkedList<Class<C>> inheritedList = ReflectUtils.getOrderedImplementedInterfaces(referenceInterface, interfaces[index]);
                while (!inheritedList.isEmpty()) {
                    Class<C> inheritedClass = inheritedList.removeFirst();
                    if (list.contains(inheritedClass)) continue;
                    list.offer(inheritedClass);
                }
            }
        }
        return list;
    }

    public static <C, T> T getConstantValue(Deque<Class<C>> list, String constantName, boolean fromTop) {
        Class<C> resourceInterface;
        Iterator<Class<C>> iterator;
        T constantValue = null;
        Iterator<Class<C>> iterator2 = iterator = fromTop ? list.descendingIterator() : list.iterator();
        while (iterator.hasNext() && (constantValue = (T)ReflectUtils.getConstantValue(resourceInterface = iterator.next(), constantName)) == null) {
        }
        return constantValue;
    }

    public static <C, T> T getConstantValue(Class<C> clazz, String constantName) {
        Object constantValue = null;
        try {
            constantValue = clazz.getField(constantName).get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)constantValue;
    }

    public static <A extends Annotation> Map<Field, A> getAnnotatedFields(Class<?> annotated, Class<A> annotationClass) {
        int length;
        if (annotated == null || annotationClass == null) {
            return Collections.emptyMap();
        }
        HashMap<Field, Object> annotatedFields = new HashMap<Field, Object>();
        Field[] fields = annotated.getDeclaredFields();
        Object annotation = null;
        int n = length = fields == null ? 0 : fields.length;
        for (int index = 0; index < length; ++index) {
            A a = fields[index].getAnnotation(annotationClass);
            annotation = a;
            if (a == null) continue;
            annotatedFields.put(fields[index], annotation);
            annotation = null;
        }
        return annotatedFields;
    }

    public static <A extends Annotation> Map<Method, A> getAnnotatedMethods(Class<?> annotated, Class<A> annotationClass) {
        if (annotated == null || annotationClass == null) {
            return Collections.emptyMap();
        }
        HashMap annotatedMethods = new HashMap();
        ReflectUtils.getAnnotatedMethods(annotated, annotationClass, annotatedMethods);
        return annotatedMethods;
    }

    private static final <A extends Annotation> void getAnnotatedMethods(Class<?> annotated, Class<A> annotationClass, Map<Method, A> map) {
        if (annotated == null) {
            return;
        }
        Method[] methods = annotated.getDeclaredMethods();
        Set<Method> methodsSet = map.keySet();
        Object annotation = null;
        for (int index = 0; index < methods.length; ++index) {
            if (methods[index].isSynthetic() || methods[index].isBridge() || ReflectUtils.containsSignature(methods[index], methodsSet) != null) continue;
            A a = ReflectUtils.getAnnotation(methods[index], annotationClass);
            annotation = a;
            if (a == null) continue;
            map.put(methods[index], annotation);
        }
        ReflectUtils.getAnnotatedMethods(annotated.getSuperclass(), annotationClass, map);
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationClass) {
        A annotation;
        block1: {
            Method implementedMethod;
            annotation = ReflectUtils.retrieveInheritedAnnotation(method, annotationClass);
            if (annotation != null) break block1;
            LinkedList<Class<?>> implementedInterfaces = ReflectUtils.getOrderedImplementedInterfaces(method.getDeclaringClass());
            Iterator iterator = implementedInterfaces.iterator();
            while (iterator.hasNext() && ((implementedMethod = ReflectUtils.containsSignature(method, Arrays.asList(((Class)iterator.next()).getDeclaredMethods()))) == null || (annotation = implementedMethod.getAnnotation(annotationClass)) == null)) {
            }
        }
        return annotation;
    }

    private static final <A extends Annotation> A retrieveInheritedAnnotation(Method method, Class<A> annotationClass) {
        if (method == null || annotationClass == null) {
            return null;
        }
        A annotation = method.getAnnotation(annotationClass);
        if (annotation == null) {
            annotation = ReflectUtils.retrieveInheritedAnnotation(ReflectUtils.overwritten(method), annotationClass);
        }
        return annotation;
    }

    public static boolean validMethod(Method method, Class<?> returnedType, String methodName, Class<?>[] parameterTypes, boolean acceptVoid, boolean strict) {
        int parameterIndex;
        int parametersLength;
        if (method == null) {
            return false;
        }
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        int n = parametersLength = parameterTypes == null ? 0 : parameterTypes.length;
        if (!(parametersLength == methodParameterTypes.length && (!strict || methodName != null && methodName.equals(method.getName())) && (returnedType != null && returnedType.isAssignableFrom(method.getReturnType()) || acceptVoid && method.getReturnType().equals(Void.TYPE)))) {
            return false;
        }
        for (parameterIndex = 0; parameterIndex < parametersLength && methodParameterTypes[parameterIndex].isAssignableFrom(parameterTypes[parameterIndex]); ++parameterIndex) {
        }
        return parameterIndex == parametersLength;
    }

    public static Method getDeclaredMethod(Method[] methods, Class<?> returnedType, Class<?>[] parameterTypes, boolean acceptVoid) {
        int length = methods == null ? 0 : methods.length;
        Method method = null;
        for (int index = 0; index < length; ++index) {
            if (!ReflectUtils.validMethod(methods[index], returnedType, null, parameterTypes, acceptVoid, false)) continue;
            method = methods[index];
            break;
        }
        return method;
    }

    public static Method getDeclaredMethod(Method[] methods, Class<?> returnedType, String methodName, Class<?>[] parameterTypes, boolean acceptVoid) {
        int length = methods == null ? 0 : methods.length;
        Method method = null;
        for (int index = 0; index < length; ++index) {
            if (!ReflectUtils.validMethod(methods[index], returnedType, methodName, parameterTypes, acceptVoid, methodName != null)) continue;
            method = methods[index];
            break;
        }
        return method;
    }

    public static Method getDeclaredMethod(Class<?> declaringClass, Class<?> returnedType, String methodName, Class<?>[] parameterTypes, boolean acceptVoid) {
        Method method;
        if (declaringClass == null || methodName == null || returnedType == null && !acceptVoid) {
            return null;
        }
        if (returnedType == null) {
            returnedType = Void.class;
        }
        if ((method = ReflectUtils.getDeclaredMethod(declaringClass.getMethods(), returnedType, methodName, parameterTypes, acceptVoid)) == null) {
            method = ReflectUtils.getDeclaredMethod(declaringClass.getDeclaredMethods(), returnedType, methodName, parameterTypes, acceptVoid);
        }
        return method;
    }

    public static Method overwritten(Method method) {
        Method overwritten = null;
        if (method != null) {
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (Class<?> declaringClass = method.getDeclaringClass().getSuperclass(); overwritten == null && declaringClass != null; declaringClass = declaringClass.getSuperclass()) {
                try {
                    overwritten = declaringClass.getDeclaredMethod(methodName, parameterTypes);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return overwritten;
    }

    public static <E, F> F getInstance(Class<E> baseClass, Class<F> implementationClass, Object ... parameters) {
        F instance;
        block7: {
            if (baseClass == implementationClass) {
                return ReflectUtils.getInstance(implementationClass, parameters);
            }
            instance = null;
            try {
                if (implementationClass != null && baseClass != null && baseClass.isAssignableFrom(implementationClass)) {
                    Constructor<?>[] constructors;
                    if (parameters == null || parameters.length == 0) {
                        instance = implementationClass.newInstance();
                        break block7;
                    }
                    for (Constructor<?> constructor : constructors = implementationClass.getDeclaredConstructors()) {
                        int index;
                        Class<?>[] parameterTypes = null;
                        parameterTypes = constructor.getParameterTypes();
                        if (parameterTypes.length != parameters.length) continue;
                        for (index = 0; index < parameterTypes.length && (parameters[index] == null || parameterTypes[index].isAssignableFrom(parameters[index].getClass())); ++index) {
                        }
                        if (index != parameterTypes.length) continue;
                        constructor.setAccessible(true);
                        instance = (F)constructor.newInstance(parameters);
                        break block7;
                    }
                    break block7;
                }
                LOGGER.log(Level.CONFIG, baseClass.getName() + " is not assignable from " + implementationClass.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.log(Level.CONFIG, e.getMessage(), e);
            }
        }
        return instance;
    }

    public static <F> F getInstance(Class<F> implementationClass, Object[] parameters) {
        F instance = null;
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = implementationClass.getDeclaredConstructors()) {
                int index;
                Class<?>[] parameterTypes = null;
                parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length != parameters.length) continue;
                for (index = 0; index < parameterTypes.length && (parameters[index] == null || parameterTypes[index].isAssignableFrom(parameters[index].getClass())); ++index) {
                }
                if (index != parameterTypes.length) continue;
                constructor.setAccessible(true);
                instance = (F)constructor.newInstance(parameters);
                break;
            }
            if (instance == null) {
                instance = implementationClass.newInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.log(Level.CONFIG, e.getMessage(), e);
        }
        return instance;
    }

    public static <F> F getTheBestInstance(Class<F> clazz, Object[] parameters) {
        int index;
        F instance = null;
        Constructor<?>[] constructors = clazz.getConstructors();
        for (index = constructors.length - 1; index >= 0; --index) {
            Constructor<?> previous;
            Constructor<?> current = constructors[index];
            for (int pos = index; pos > 0 && (previous = constructors[pos - 1]).getParameterTypes().length < current.getParameterTypes().length; --pos) {
                constructors[pos] = previous;
                constructors[pos - 1] = current;
            }
        }
        boolean position = false;
        for (index = 0; index < constructors.length; ++index) {
            int parametersLength;
            Class<?>[] parameterTypes = constructors[index].getParameterTypes();
            if (parameterTypes.length > parameters.length) continue;
            Object[] params = new Object[parameterTypes.length];
            int paramsIndex = 0;
            int n = parametersLength = parameters == null ? 0 : parameters.length;
            for (int parametersIndex = 0; parametersIndex < parametersLength && paramsIndex < params.length; ++parametersIndex) {
                Object parameter = parameters[parametersIndex];
                if (parameter == null || !parameterTypes[paramsIndex].isAssignableFrom(parameter.getClass())) continue;
                params[paramsIndex++] = parameter;
            }
            if (paramsIndex != parameterTypes.length) continue;
            try {
                instance = (F)constructors[index].newInstance(params);
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return instance;
    }

    public static <E, T> T instantiate(Class<T> clazz, JSONArray jsonObject) {
        T instance = null;
        if (jsonObject == null) {
            return instance;
        }
        Constructor<T> constructor = null;
        try {
            constructor = clazz.getConstructor(JSONArray.class);
            instance = constructor.newInstance(jsonObject);
        }
        catch (Exception e) {
            try {
                constructor = clazz.getConstructor(JSONArray.class);
                instance = constructor.newInstance(jsonObject);
            }
            catch (Exception ex) {
                LOGGER.log(Level.CONFIG, e.getMessage(), e);
            }
        }
        if (instance != null) {
            return instance;
        }
        Object[][] parameters = null;
        int length = jsonObject.length();
        parameters = new Object[length][2];
        for (int i = 0; i < length; ++i) {
            parameters[i][0] = null;
            parameters[i][1] = jsonObject.get(i);
        }
        return ReflectUtils.newInstance(clazz, parameters);
    }

    public static <E, T> T instantiate(Class<T> clazz, JSONObject jsonObject) {
        T instance = null;
        if (jsonObject == null) {
            return instance;
        }
        Constructor<T> constructor = null;
        try {
            constructor = clazz.getConstructor(JSONObject.class);
            instance = constructor.newInstance(jsonObject);
        }
        catch (Exception e) {
            try {
                constructor = clazz.getConstructor(JSONObject.class);
                instance = constructor.newInstance(jsonObject);
            }
            catch (Exception ex) {
                LOGGER.log(Level.CONFIG, e.getMessage(), e);
            }
        }
        if (instance != null) {
            return instance;
        }
        Object[][] parameters = null;
        String[] names = JSONObject.getNames(jsonObject);
        int length = names.length;
        parameters = new Object[length][2];
        for (int i = 0; i < length; ++i) {
            parameters[i][0] = names[i];
            parameters[i][1] = jsonObject.get(names[i]);
        }
        return ReflectUtils.newInstance(clazz, parameters);
    }

    private static final <E, T> T newInstance(Class<T> clazz, Object[][] parameters) {
        int index;
        T instance = null;
        Constructor<?>[] constructors = clazz.getConstructors();
        for (index = constructors.length - 1; index >= 0; --index) {
            Constructor<?> previous;
            Constructor<?> current = constructors[index];
            for (int pos = index; pos > 0 && (previous = constructors[pos - 1]).getParameterTypes().length < current.getParameterTypes().length; --pos) {
                constructors[pos] = previous;
                constructors[pos - 1] = current;
            }
        }
        int position = 0;
        for (index = constructors.length - 1; index >= 0; --index) {
            int typeIndex;
            if (constructors[index].getParameterTypes().length > parameters.length) continue;
            Class<?>[] parameterTypes = constructors[index].getParameterTypes();
            Object[] params = new Object[parameterTypes.length];
            for (typeIndex = 0; typeIndex < parameterTypes.length; ++typeIndex) {
                Object parameter = CastUtils.getObjectFromJSON(parameterTypes[typeIndex], parameters[typeIndex][1]);
                if (parameter == null && !JSONObject.NULL.equals(parameters[typeIndex][1])) {
                    params = null;
                    break;
                }
                params[typeIndex] = parameter;
            }
            if (params == null) continue;
            try {
                instance = (T)constructors[index].newInstance(params);
                position = typeIndex + 1;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (instance != null && position < parameters.length && parameters[position][0] != null) {
            while (position < parameters.length) {
                try {
                    Field field = clazz.getDeclaredField((String)parameters[position][0]);
                    Object value = parameters[position][1];
                    if (value != null && (field.getModifiers() & 0x10) != 16 && (field.getModifiers() & 8) != 8) {
                        field.setAccessible(true);
                        if (List.class.isAssignableFrom(field.getType())) {
                            field.set(instance, CastUtils.toList(field.getType(), (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0], (JSONArray)value));
                        } else if (Map.class.isAssignableFrom(field.getType())) {
                            field.set(instance, CastUtils.toMap(field.getType(), (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1], (JSONObject)value));
                        } else {
                            field.set(instance, CastUtils.getObjectFromJSON(field.getType(), value));
                        }
                    }
                }
                catch (Exception exception) {
                    LOGGER.log(Level.CONFIG, exception.getMessage(), exception);
                }
                ++position;
            }
        }
        return instance;
    }

    public static List<Class<?>> getAssignableTypes(Class<?> type, Bundle bundle) {
        return ReflectUtils.getAssignableTypes(type, ReflectUtils.getAllTypes(bundle));
    }

    public static List<Class<?>> getAssignableTypes(Class<?> type, List<Class<?>> classes) {
        ArrayList assignables = new ArrayList();
        for (Class<?> clazz : classes) {
            if (!type.isAssignableFrom(clazz)) continue;
            assignables.add(clazz);
        }
        return assignables;
    }

    public static List<String> getAllStringTypes(Bundle bundle) {
        ArrayList<String> types = new ArrayList<String>();
        Enumeration entries = bundle.findEntries("/", "*.class", true);
        if (entries != null) {
            while (entries.hasMoreElements()) {
                String classname = ((URL)entries.nextElement()).getPath();
                int startIndex = 0;
                int endIndex = classname.length() - ".class".length();
                classname = classname.substring(startIndex += classname.startsWith("/") ? 1 : 0, endIndex);
                classname = classname.replace('/', '.');
                types.add(classname);
            }
        }
        return types;
    }

    public static List<Class<?>> getAllTypes(Bundle bundle) {
        List<String> strTypes = ReflectUtils.getAllStringTypes(bundle);
        ArrayList types = new ArrayList();
        if (strTypes == null || strTypes.size() == 0) {
            return types;
        }
        Iterator<String> iterator = strTypes.iterator();
        while (iterator.hasNext()) {
            try {
                types.add(bundle.loadClass(iterator.next()));
            }
            catch (ClassNotFoundException ex) {}
        }
        return types;
    }

    public static Class<?> getClass(Type type) {
        Type componentType;
        Class<?> componentClass;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType && (componentClass = ReflectUtils.getClass(componentType = ((GenericArrayType)type).getGenericComponentType())) != null) {
            return Array.newInstance(componentClass, 0).getClass();
        }
        return null;
    }

    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap resolvedTypes = new HashMap();
        Type type = childClass;
        while (!ReflectUtils.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(baseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(ReflectUtils.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }
}

