/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.agent.storage.influxdb.read;

import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.sensinact.gateway.historic.storage.reader.api.HistoricRequest;
import org.eclipse.sensinact.gateway.historic.storage.reader.api.TemporalDTO;
import org.eclipse.sensinact.gateway.tools.connector.influxdb.InfluxDBTagDTO;
import org.eclipse.sensinact.gateway.tools.connector.influxdb.InfluxDbConnector;
import org.eclipse.sensinact.gateway.tools.connector.influxdb.InfluxDbDatabase;
import org.influxdb.dto.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InfluxDBRequest<T>
implements HistoricRequest<T> {
    private static final Logger LOG = LoggerFactory.getLogger(InfluxDBRequest.class);
    private static final List<String> REPLACEMENTS = Arrays.asList(":", ".", "-", "[", "]", "(", ")", "{", "}", "+");
    protected String database;
    protected String measurement;
    protected String provider;
    protected String service;
    protected String resource;
    protected LocalDateTime start;
    protected LocalDateTime end;
    protected InfluxDbConnector influxDbConnector;

    public InfluxDBRequest(InfluxDbConnector influxDbConnector) {
        this.influxDbConnector = influxDbConnector;
    }

    public void setMeasurement(String measurement) {
        this.measurement = measurement;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setServiceProviderIdentifier(String provider) {
        this.provider = provider;
    }

    public void setServiceIdentifier(String service) {
        this.service = service;
    }

    public void setResourceIdentifier(String resource) {
        this.resource = resource;
    }

    public void setHistoricStartTime(LocalDateTime fromTime) {
        this.start = fromTime;
    }

    public void setHistoricEndTime(LocalDateTime toTime) {
        this.end = toTime;
    }

    protected InfluxDBTagDTO getDataSourcePath() {
        InfluxDBTagDTO historicAttributeDTO = new InfluxDBTagDTO();
        historicAttributeDTO.name = "path";
        String datasource = null;
        if (this.resource == null) {
            if (this.provider == null) {
                return null;
            }
            datasource = this.provider;
            for (String replacement : REPLACEMENTS) {
                datasource = datasource.replace(replacement, "\\".concat(replacement));
            }
            historicAttributeDTO.value = "/(" + datasource + "\\/([^\\/]+\\/?)+)/";
            historicAttributeDTO.pattern = true;
            return historicAttributeDTO;
        }
        if (this.provider == null) {
            if (this.service == null) {
                return null;
            }
            datasource = this.service;
            for (String replacement : REPLACEMENTS) {
                datasource = datasource.replace(replacement, "\\".concat(replacement));
            }
            historicAttributeDTO.value = datasource = "/([^\\/]+\\/" + datasource + "\\/[^\\/]+)/";
            historicAttributeDTO.pattern = true;
            return historicAttributeDTO;
        }
        historicAttributeDTO.value = "/" + this.provider + "/" + this.service + "/" + this.resource + "/" + "value";
        historicAttributeDTO.pattern = false;
        return historicAttributeDTO;
    }

    protected InfluxDBTagDTO getResource() {
        if (this.resource == null) {
            return null;
        }
        InfluxDBTagDTO historicAttributeDTO = new InfluxDBTagDTO();
        historicAttributeDTO.name = "resource";
        historicAttributeDTO.value = this.resource;
        historicAttributeDTO.pattern = false;
        return historicAttributeDTO;
    }

    private List<TemporalDTO> buildTemporalDTOList(QueryResult result) {
        List serie = null;
        try {
            serie = ((QueryResult.Series)((QueryResult.Result)result.getResults().get(0)).getSeries().get(0)).getValues();
        }
        catch (NullPointerException e) {
            return Collections.emptyList();
        }
        ArrayList<TemporalDTO> list = new ArrayList<TemporalDTO>();
        for (int i = 0; i < serie.size(); ++i) {
            TemporalDTO dto = null;
            try {
                dto = new TemporalDTO();
                dto.tagID = i;
                dto.timestamp = Instant.parse(String.valueOf(((List)serie.get(i)).get(0))).toEpochMilli();
                dto.value = String.valueOf(((List)serie.get(i)).get(1));
                list.add(dto);
                continue;
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                if (dto == null) continue;
                dto.error = e.getMessage();
                list.add(dto);
            }
        }
        return list;
    }

    protected List<TemporalDTO> get(InfluxDbDatabase db, String measurement, List<InfluxDBTagDTO> tags) {
        QueryResult result = db.getResult(measurement, tags, Arrays.asList("time", "value"));
        List<TemporalDTO> list = this.buildTemporalDTOList(result);
        return list;
    }

    protected List<TemporalDTO> get(InfluxDbDatabase db, String measurement, List<InfluxDBTagDTO> tags, String function, long timeWindow) {
        QueryResult result = db.getResult(measurement, tags, "value", function, timeWindow);
        List<TemporalDTO> list = this.buildTemporalDTOList(result);
        return list;
    }

    protected List<TemporalDTO> get(InfluxDbDatabase db, String measurement, List<InfluxDBTagDTO> tags, LocalDateTime start) {
        QueryResult result = db.getResult(measurement, tags, Arrays.asList("time", "value"), start);
        List<TemporalDTO> list = this.buildTemporalDTOList(result);
        return list;
    }

    protected List<TemporalDTO> get(InfluxDbDatabase db, String measurement, List<InfluxDBTagDTO> tags, String function, long timeWindow, LocalDateTime start) {
        QueryResult result = db.getResult(measurement, tags, "value", function, timeWindow, start);
        List<TemporalDTO> list = this.buildTemporalDTOList(result);
        return list;
    }

    protected List<TemporalDTO> get(InfluxDbDatabase db, String measurement, List<InfluxDBTagDTO> tags, LocalDateTime start, LocalDateTime end) {
        QueryResult result = db.getResult(measurement, tags, Arrays.asList("time", "value"), start, end);
        List<TemporalDTO> list = this.buildTemporalDTOList(result);
        return list;
    }

    protected List<TemporalDTO> get(InfluxDbDatabase db, String measurement, List<InfluxDBTagDTO> tags, String function, long timeWindow, LocalDateTime start, LocalDateTime end) {
        QueryResult result = db.getResult(measurement, tags, "value", function, timeWindow, start, end);
        List<TemporalDTO> list = this.buildTemporalDTOList(result);
        return list;
    }
}

