/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.topologymanager.exporter;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.aries.rsa.topologymanager.exporter.EndpointListenerNotifier;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointEvent;
import org.osgi.service.remoteserviceadmin.ExportReference;
import org.osgi.service.remoteserviceadmin.ExportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceExportsRepository
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceExportsRepository.class);
    private RemoteServiceAdmin rsa;
    private EndpointListenerNotifier notifier;
    private final Map<ServiceReference<?>, Collection<ExportRegistrationHolder>> exportsMap = new LinkedHashMap();

    public ServiceExportsRepository(RemoteServiceAdmin rsa, EndpointListenerNotifier notifier) {
        this.rsa = rsa;
        this.notifier = notifier;
    }

    @Override
    public void close() {
        LOG.debug("Closing registry for RemoteServiceAdmin {}", (Object)this.rsa.getClass().getName());
        for (ServiceReference<?> sref : this.exportsMap.keySet()) {
            this.removeService(sref);
        }
    }

    public synchronized void addService(ServiceReference<?> sref, Collection<ExportRegistration> exports) {
        ArrayList<ExportRegistrationHolder> holderList = new ArrayList<ExportRegistrationHolder>(exports.size());
        this.exportsMap.put(sref, holderList);
        for (ExportRegistration reg : exports) {
            ExportReference exportReference = reg.getExportReference();
            if (exportReference == null) continue;
            EndpointDescription endpoint = exportReference.getExportedEndpoint();
            ExportRegistrationHolder holder = new ExportRegistrationHolder(reg, endpoint);
            holderList.add(holder);
        }
    }

    public synchronized void modifyService(ServiceReference<?> sref) {
        Collection<ExportRegistrationHolder> exports = this.exportsMap.get(sref);
        if (exports != null) {
            for (ExportRegistrationHolder reg : exports) {
                reg.update(sref);
            }
        }
    }

    public synchronized void removeService(ServiceReference<?> sref) {
        Collection<ExportRegistrationHolder> exports = this.exportsMap.get(sref);
        if (exports != null) {
            for (ExportRegistrationHolder reg : exports) {
                reg.close();
            }
            exports.clear();
        }
    }

    public List<EndpointDescription> getAllEndpoints() {
        ArrayList<EndpointDescription> endpoints = new ArrayList<EndpointDescription>();
        for (ServiceReference<?> sref : this.exportsMap.keySet()) {
            Collection<ExportRegistrationHolder> exports = this.exportsMap.get(sref);
            for (ExportRegistrationHolder reg : exports) {
                ExportReference exportRef = reg.getRegistration().getExportReference();
                if (exportRef == null) continue;
                endpoints.add(exportRef.getExportedEndpoint());
            }
        }
        return endpoints;
    }

    private class ExportRegistrationHolder {
        private final ExportRegistration registration;
        private final ExportReference reference;
        private EndpointDescription endpoint;

        ExportRegistrationHolder(ExportRegistration registration, EndpointDescription endpoint) {
            this.registration = registration;
            this.reference = registration.getExportReference();
            this.endpoint = endpoint;
            EndpointEvent event = new EndpointEvent(1, endpoint);
            ServiceExportsRepository.this.notifier.sendEvent(event);
        }

        ExportRegistration getRegistration() {
            return this.registration;
        }

        void close() {
            if (this.reference != null) {
                ServiceExportsRepository.this.notifier.sendEvent(new EndpointEvent(2, this.endpoint));
                this.registration.close();
            }
        }

        public void update(ServiceReference<?> sref) {
            EndpointDescription updatedEndpoint = this.registration.update(this.getServiceProps(sref));
            if (this.reference != null) {
                this.endpoint = updatedEndpoint;
                EndpointEvent event = new EndpointEvent(4, this.endpoint);
                ServiceExportsRepository.this.notifier.sendEvent(event);
            }
        }

        private Map<String, ?> getServiceProps(ServiceReference<?> sref) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            for (String key : sref.getPropertyKeys()) {
                props.put(key, sref.getProperty(key));
            }
            return props;
        }
    }
}

