/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.sensinact.gateway.app.api.exception.FunctionNotFoundException;
import org.eclipse.sensinact.gateway.app.manager.json.AppComponent;
import org.eclipse.sensinact.gateway.app.manager.json.AppEvent;
import org.eclipse.sensinact.gateway.app.manager.json.AppFinalize;
import org.eclipse.sensinact.gateway.app.manager.json.AppInitialize;
import org.eclipse.sensinact.gateway.app.manager.json.AppParameter;
import org.eclipse.sensinact.gateway.app.manager.osgi.AppServiceMediator;
import org.eclipse.sensinact.gateway.common.primitive.JSONable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppContainer
implements JSONable {
    private static final Logger LOG = LoggerFactory.getLogger(AppContainer.class);
    private final String applicationName;
    private final AppInitialize initialize;
    private final List<AppComponent> components;
    private final AppFinalize finalize;

    public AppContainer(AppServiceMediator mediator, String applicationName, JSONObject content) {
        this.applicationName = applicationName;
        this.initialize = new AppInitialize(content.has("initialize") ? content.optJSONObject("initialize") : new JSONObject());
        this.components = new ArrayList<AppComponent>();
        this.finalize = new AppFinalize(content.has("finalize") ? content.optJSONObject("finalize") : new JSONObject());
        JSONArray componentArray = content.optJSONArray("application");
        for (int i = 0; i < componentArray.length(); ++i) {
            AppComponent component;
            try {
                component = new AppComponent(mediator, componentArray.getJSONObject(i));
            }
            catch (FunctionNotFoundException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Unable to create the component", (Throwable)e);
                }
                return;
            }
            this.components.add(component);
        }
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public AppInitialize getInitialize() {
        return this.initialize;
    }

    public List<AppComponent> getComponents() {
        return this.components;
    }

    public AppFinalize getFinalize() {
        return this.finalize;
    }

    public Collection<String> getResourceUris() {
        HashSet<String> resourceUris = new HashSet<String>();
        for (AppComponent component : this.getComponents()) {
            for (AppEvent event : component.getEvents()) {
                if (!AppEvent.EventType.RESOURCE.equals((Object)event.getType())) continue;
                resourceUris.add(event.getUri());
            }
            for (AppParameter parameter : component.getFunction().getRunParameters()) {
                if (!"resource".equals(parameter.getType())) continue;
                resourceUris.add((String)parameter.getValue());
            }
        }
        return resourceUris;
    }

    public String getJSON() {
        JSONObject application = new JSONObject();
        application.put("initialize", (Object)this.initialize.getJSON());
        JSONArray componentArray = new JSONArray();
        for (AppComponent component : this.components) {
            componentArray.put((Object)component.getJSON());
        }
        application.put("application", (Object)componentArray);
        application.put("finalize", (Object)this.finalize.getJSON());
        return application.toString();
    }
}

