/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.primitive.DescribablePrimitive;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueTypeException;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.core.MetadataDescription;
import org.json.JSONObject;

public class Metadata
extends DescribablePrimitive {
    public static final String HIDDEN = "hidden";
    public static final String MODIFIABLE = "modifiable";
    public static final String TIMESTAMP = "timestamp";
    public static final String DEFAULT = "default";
    public static final String DESCRIPTION = "description";
    public static final String UNIT = "unit";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String CONSTRAINTS = "constraints";
    public static final String NOTIFY = "notify";
    public static final String LOCKED = "locked";
    private Modifiable modifiable = Modifiable.UPDATABLE;

    public Metadata(Mediator mediator, String name, Class<?> type, Object value, Modifiable modifiable) throws InvalidValueException {
        super(mediator, name, type, value);
        this.modifiable = modifiable;
    }

    public Metadata(Mediator mediator, JSONObject metadata) throws InvalidValueException {
        super(mediator, metadata);
        try {
            this.modifiable = Modifiable.valueOf((String)metadata.optString(MODIFIABLE));
        }
        catch (Exception e) {
            this.modifiable = Modifiable.FIXED;
        }
    }

    public Modifiable getModifiable() {
        return this.modifiable;
    }

    protected MetadataDescription createDescription() {
        return new MetadataDescription(this);
    }

    protected void checkType(Class<?> type) throws InvalidValueTypeException {
        if (!type.isArray() || !Constraint.class.isAssignableFrom(type.getComponentType())) {
            super.checkType(type);
        }
    }
}

