/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.primitive.Nameable;
import org.eclipse.sensinact.gateway.common.primitive.PathElement;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.util.UriUtils;

public abstract class ModelElementProxy
implements Nameable,
PathElement {
    protected final Class<?> proxied;
    protected final String path;
    protected Mediator mediator;
    private String name;

    protected abstract AccessMethod<?, ?> getAccessMethod(String var1);

    protected ModelElementProxy(Mediator mediator, Class<?> proxied, String path) {
        this.path = path;
        this.name = UriUtils.getLeaf((String)path);
        this.mediator = mediator;
        this.proxied = proxied;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getProxied() {
        return this.proxied;
    }

    public AccessMethodResponse<?> invoke(String type, Object[] parameters) throws Throwable {
        AccessMethod<?, ?> accessMethod = this.getAccessMethod(type);
        if (accessMethod == null) {
            Object message = AccessMethodResponse.error(this.mediator, this.path, AccessMethod.Type.valueOf(type), 404, type + " method not found", null);
            return message;
        }
        return accessMethod.invoke(parameters);
    }
}

