/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method.builder;

import java.util.ArrayList;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.constraint.ConstraintConstantPair;
import org.eclipse.sensinact.gateway.common.constraint.ConstraintFactory;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.core.method.DynamicParameterValue;
import org.eclipse.sensinact.gateway.core.method.builder.AbstractDynamicParameterValue;
import org.eclipse.sensinact.gateway.core.method.builder.ConditionalConstant;
import org.eclipse.sensinact.gateway.core.method.builder.Copy;
import org.eclipse.sensinact.gateway.core.method.builder.DynamicParameterValueFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class DefaultDynamicParameterValueFactory
implements DynamicParameterValueFactory {
    @Override
    public boolean handle(String type) {
        try {
            return DynamicParameterValue.Type.valueOf(type) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public DynamicParameterValue newInstance(Mediator mediator, Executable<Void, Object> resourceValueExtractor, JSONObject jsonBuilder) throws InvalidValueException {
        if (JSONObject.NULL.equals(jsonBuilder)) {
            throw new InvalidValueException("Null JSON trigger definition");
        }
        AbstractDynamicParameterValue builder = null;
        try {
            String jsonType = jsonBuilder.getString("type");
            DynamicParameterValue.Type type = DynamicParameterValue.Type.valueOf(jsonType);
            String resourceName = jsonBuilder.optString("resource");
            String parameterName = jsonBuilder.optString("parameter");
            switch (type) {
                case CONDITIONAL: {
                    int length;
                    ArrayList<ConstraintConstantPair> constraints = new ArrayList<ConstraintConstantPair>();
                    JSONArray constants = jsonBuilder.optJSONArray("constants");
                    int n = length = constants == null ? 0 : constants.length();
                    for (int constantsIndex = 0; constantsIndex < length; ++constantsIndex) {
                        JSONObject constantObject = constants.getJSONObject(constantsIndex);
                        constraints.add(new ConstraintConstantPair(ConstraintFactory.Loader.load((ClassLoader)mediator.getClassLoader(), (Object)constantObject.opt("constraint")), constantObject.opt("constant")));
                    }
                    builder = new ConditionalConstant(mediator, parameterName, resourceName, constraints);
                    break;
                }
                case COPY: {
                    builder = new Copy(mediator, parameterName, resourceName);
                    break;
                }
                default: {
                    throw new InvalidValueException("Unknown builder identifier :" + jsonType);
                }
            }
        }
        catch (Exception e) {
            throw new InvalidValueException((Throwable)e);
        }
        ((AbstractDynamicParameterValue)builder).setResourceValueExtractor(resourceValueExtractor);
        return builder;
    }
}

