/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.application;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.sensinact.gateway.app.api.exception.LifeCycleException;
import org.eclipse.sensinact.gateway.app.api.plugin.PluginHook;
import org.eclipse.sensinact.gateway.app.manager.component.DataListenerItf;
import org.eclipse.sensinact.gateway.app.manager.component.DataProviderItf;
import org.eclipse.sensinact.gateway.app.manager.component.Event;
import org.eclipse.sensinact.gateway.app.manager.osgi.AppServiceMediator;
import org.osgi.framework.ServiceReference;

class ActionHookQueue
implements DataListenerItf {
    private final AppServiceMediator mediator;
    private final Queue<PluginHook> actionQueue;

    ActionHookQueue(AppServiceMediator mediator) {
        this.mediator = mediator;
        this.actionQueue = new ConcurrentLinkedQueue<PluginHook>();
    }

    public void instantiate() throws LifeCycleException {
        try {
            String filter = "(&(objectClass=" + DataProviderItf.class.getName() + ")(type=" + PluginHook.class.getName() + "))";
            ServiceReference<?>[] serviceReferences = this.mediator.getServiceReferences(filter);
            if (serviceReferences != null) {
                for (ServiceReference<?> serviceReference : serviceReferences) {
                    DataProviderItf dataProviderItf = (DataProviderItf)this.mediator.getService(serviceReference);
                    dataProviderItf.addListener(this, null);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LifeCycleException("Unable to instantiate the ActionHookQueue > " + e.getMessage());
        }
    }

    public void uninstantiate() throws LifeCycleException {
        try {
            ServiceReference[] serviceReferences;
            String filter = "(&(objectClass=" + DataProviderItf.class.getName() + ")(type=" + PluginHook.class.getName() + "))";
            for (ServiceReference serviceReference : serviceReferences = this.mediator.getContext().getServiceReferences((String)null, filter)) {
                DataProviderItf dataProviderItf = (DataProviderItf)this.mediator.getService(serviceReference);
                dataProviderItf.removeListener(this);
            }
        }
        catch (Exception e) {
            throw new LifeCycleException("Unable to uninstantiate the ActionHookQueue > " + e.getMessage());
        }
    }

    @Override
    public void eventNotification(Event event) {
        this.actionQueue.add((PluginHook)event.getData().getValue());
    }

    void fireHooks() {
        try {
            for (PluginHook hook : this.actionQueue) {
                hook.fireHook();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.actionQueue.clear();
        }
    }
}

