/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.android;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.local.LocalProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.sthbnd.http.android.AndroidWebSocketWrapper;
import org.eclipse.sensinact.gateway.sthbnd.http.android.DevGenPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidWebSocketPool
implements WebSocketCreator {
    private static final Logger LOG = LoggerFactory.getLogger(AndroidWebSocketPool.class);
    private final LocalProtocolStackEndpoint<DevGenPacket> endpoint;
    private Mediator mediator;
    private List<AndroidWebSocketWrapper> sessions;

    public AndroidWebSocketPool(Mediator mediator, LocalProtocolStackEndpoint<DevGenPacket> endpoint) {
        this.mediator = mediator;
        this.endpoint = endpoint;
        this.sessions = new ArrayList<AndroidWebSocketWrapper>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSensinactSocket(AndroidWebSocketWrapper wsWrapper) {
        LOG.info(String.format("Removing session for client address %s.", wsWrapper.getClientAddress()));
        Boolean removedSuccessfully = true;
        List<AndroidWebSocketWrapper> list = this.sessions;
        synchronized (list) {
            removedSuccessfully = this.sessions.remove(wsWrapper);
            if (removedSuccessfully.booleanValue()) {
                wsWrapper.close();
            }
        }
        LOG.warn(String.format("Session removal %s executed.", removedSuccessfully != false ? "successfully" : "not"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<AndroidWebSocketWrapper> list = this.sessions;
        synchronized (list) {
            while (!this.sessions.isEmpty()) {
                this.sessions.remove(0).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
        AndroidWebSocketWrapper wrapper = new AndroidWebSocketWrapper(this.mediator, this.endpoint);
        if (wrapper != null) {
            List<AndroidWebSocketWrapper> list = this.sessions;
            synchronized (list) {
                this.sessions.add(wrapper);
            }
        }
        return wrapper;
    }
}

