/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.application;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sensinact.gateway.app.api.lifecycle.ApplicationStatus;
import org.eclipse.sensinact.gateway.app.manager.application.AppExceptionExecutor;
import org.eclipse.sensinact.gateway.app.manager.application.AppLifecycleTrigger;
import org.eclipse.sensinact.gateway.app.manager.application.AppStartExecutor;
import org.eclipse.sensinact.gateway.app.manager.application.AppStopExecutor;
import org.eclipse.sensinact.gateway.app.manager.application.AppWatchdogExecutor;
import org.eclipse.sensinact.gateway.app.manager.application.Application;
import org.eclipse.sensinact.gateway.app.manager.json.AppContainer;
import org.eclipse.sensinact.gateway.app.manager.osgi.AppServiceMediator;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.core.ActionResource;
import org.eclipse.sensinact.gateway.core.Attribute;
import org.eclipse.sensinact.gateway.core.InvalidResourceException;
import org.eclipse.sensinact.gateway.core.InvalidServiceException;
import org.eclipse.sensinact.gateway.core.ModelInstance;
import org.eclipse.sensinact.gateway.core.PropertyResource;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.ServiceProviderImpl;
import org.eclipse.sensinact.gateway.core.StateVariableResource;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethodExecutor;
import org.eclipse.sensinact.gateway.core.method.LinkedActMethod;
import org.eclipse.sensinact.gateway.core.method.Parameter;
import org.eclipse.sensinact.gateway.core.method.Shortcut;
import org.eclipse.sensinact.gateway.core.method.Signature;
import org.eclipse.sensinact.gateway.core.method.trigger.AccessMethodTrigger;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationService
extends ServiceImpl {
    private static Logger LOG = LoggerFactory.getLogger(ApplicationService.class);
    private Application application;

    public ApplicationService(ModelInstance<?> modelInstance, String name, ServiceProviderImpl device) throws InvalidServiceException {
        super(modelInstance, name, device);
    }

    public final void createSnaService(AppContainer appContainer, Application application) throws InvalidResourceException, InvalidValueException {
        AccessMethod.Type act = AccessMethod.Type.valueOf((String)AccessMethod.ACT);
        this.application = application;
        ResourceImpl startResource = this.addActionResource("START", ActionResource.class);
        startResource.registerExecutor(new Signature(this.modelInstance.mediator(), act, null, null), (AccessMethodExecutor)new AppStartExecutor(this), AccessMethodExecutor.ExecutionPolicy.AFTER);
        ResourceImpl stopResource = this.addActionResource("STOP", ActionResource.class);
        stopResource.registerExecutor(new Signature(this.modelInstance.mediator(), act, null, null), (AccessMethodExecutor)new AppStopExecutor(this), AccessMethodExecutor.ExecutionPolicy.AFTER);
        ResourceImpl exceptionResource = this.addActionResource("EXCEPTION", ActionResource.class);
        exceptionResource.registerExecutor(new Signature(this.modelInstance.mediator(), act, null, null), (AccessMethodExecutor)new AppExceptionExecutor(this), AccessMethodExecutor.ExecutionPolicy.AFTER);
        ResourceImpl uninstallResource = ((ServiceProviderImpl)this.parent).getAdminService().getResource("UNINSTALL");
        ResourceImpl uninstallLinkedResource = this.addLinkedActionResource("UNINSTALL", uninstallResource, false);
        LinkedActMethod method = (LinkedActMethod)uninstallLinkedResource.getAccessMethod(act);
        method.createShortcut(new Signature(this.modelInstance.mediator(), act, new Class[]{String.class}, null), new Shortcut(this.modelInstance.mediator(), act, new Class[0], null, (Map)new HashMap<Integer, Parameter>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(0, new Parameter(ApplicationService.this.modelInstance.mediator(), "name", String.class, (Object)ApplicationService.this.name));
            }
        }));
        ResourceImpl status = this.addDataResource(StateVariableResource.class, "status", ApplicationStatus.class, (Object)ApplicationStatus.INSTALLED);
        status.addAttribute(new Attribute(this.modelInstance.mediator(), status, "message", String.class, (Object)"Application installed", Modifiable.UPDATABLE, false));
        AppLifecycleTrigger appLifecycleTrigger = new AppLifecycleTrigger(this);
        this.addTrigger("START", "status", new Signature(this.modelInstance.mediator(), act, null, null), (AccessMethodTrigger)appLifecycleTrigger, AccessMethodExecutor.ExecutionPolicy.BEFORE);
        this.addTrigger("START", "status", new Signature(this.modelInstance.mediator(), act, null, null), (AccessMethodTrigger)appLifecycleTrigger, AccessMethodExecutor.ExecutionPolicy.AFTER);
        this.addTrigger("STOP", "status", new Signature(this.modelInstance.mediator(), act, null, null), (AccessMethodTrigger)appLifecycleTrigger, AccessMethodExecutor.ExecutionPolicy.AFTER);
        this.addTrigger("UNINSTALL", "status", new Signature(this.modelInstance.mediator(), act, null, null), (AccessMethodTrigger)appLifecycleTrigger, AccessMethodExecutor.ExecutionPolicy.BEFORE);
        this.addTrigger("EXCEPTION", "status", new Signature(this.modelInstance.mediator(), act, null, null), (AccessMethodTrigger)appLifecycleTrigger, AccessMethodExecutor.ExecutionPolicy.AFTER);
        this.addDataResource(PropertyResource.class, "content", JSONObject.class, new JSONObject(appContainer.getJSON()));
        this.addDataResource(PropertyResource.class, "resetOnStop", Boolean.TYPE, appContainer.getInitialize().getOptions().getResetOnStop());
        this.addDataResource(PropertyResource.class, "autostart", Boolean.TYPE, appContainer.getInitialize().getOptions().getAutoStart());
        AppWatchdogExecutor appWatchdogExecutor = new AppWatchdogExecutor((AppServiceMediator)this.modelInstance.mediator(), this, appContainer.getResourceUris());
        startResource.registerExecutor(new Signature(this.modelInstance.mediator(), act, null, null), (AccessMethodExecutor)appWatchdogExecutor, AccessMethodExecutor.ExecutionPolicy.BEFORE);
        stopResource.registerExecutor(new Signature(this.modelInstance.mediator(), act, null, null), (AccessMethodExecutor)appWatchdogExecutor, AccessMethodExecutor.ExecutionPolicy.AFTER);
        if (appContainer.getInitialize().getOptions().getAutoStart()) {
            LOG.debug("Application autostart option is activated, instantiating dependency manager");
        } else {
            LOG.debug("Application autostart option is NOT activated");
        }
    }

    public Application getApplication() {
        return this.application;
    }

    public void stop() {
        super.stop();
        this.application.stop();
    }
}

