/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.core.DefaultResourceConfigBuilder;
import org.eclipse.sensinact.gateway.core.ModelInstance;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.ResourceConfigBuilder;
import org.eclipse.sensinact.gateway.core.ResourceConfigCatalog;
import org.eclipse.sensinact.gateway.core.ResourceConfigCatalogCollection;
import org.eclipse.sensinact.gateway.core.ResourceDescriptor;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModelConfiguration;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.ServiceProviderImpl;
import org.eclipse.sensinact.gateway.core.security.AccessLevelOption;
import org.eclipse.sensinact.gateway.core.security.AuthorizationService;
import org.eclipse.sensinact.gateway.core.security.MethodAccessibility;
import org.eclipse.sensinact.gateway.core.security.MutableAccessNode;
import org.eclipse.sensinact.gateway.core.security.MutableAccessTree;

public class ModelConfiguration
implements SensiNactResourceModelConfiguration {
    protected Class<? extends ServiceProviderImpl> serviceProviderType = null;
    private final Class<? extends ServiceProviderImpl> defaultServiceProviderType;
    protected Class<? extends ServiceImpl> serviceType = null;
    private final Class<? extends ServiceImpl> defaultServiceType;
    protected Class<? extends ResourceImpl> resourceType = null;
    private final Class<? extends ResourceImpl> defaultResourceType;
    protected Class<? extends ModelInstance<?>> modelInstanceType;
    private ResourceConfigCatalogCollection resourceConfigCatalogs = null;
    private ResourceConfigBuilder defaultResourceConfigBuilder = null;
    private Class<? extends ResourceConfig> resourceConfigType = null;
    protected byte resourceBuildPolicy = 0;
    protected byte serviceBuildPolicy = 0;
    private boolean startAtInitializationTime;
    protected Map<String, List<String>> profiles;
    protected Map<String, List<String>> fixed;
    protected List<String> observed;
    protected final MutableAccessTree<? extends MutableAccessNode> accessTree;
    protected Mediator mediator;

    public ModelConfiguration(Mediator mediator, MutableAccessTree<? extends MutableAccessNode> accessTree) {
        this(mediator, accessTree, new DefaultResourceConfigBuilder());
    }

    public ModelConfiguration(Mediator mediator, MutableAccessTree<? extends MutableAccessNode> accessTree, ResourceConfigBuilder defaultResourceConfigBuilder) {
        this(mediator, accessTree, defaultResourceConfigBuilder, ServiceProviderImpl.class, ServiceImpl.class, ResourceImpl.class);
    }

    protected ModelConfiguration(Mediator mediator, MutableAccessTree<? extends MutableAccessNode> accessTree, Class<? extends ServiceProviderImpl> defaultServiceProviderType, Class<? extends ServiceImpl> defaultServiceType, Class<? extends ResourceImpl> defaultResourceType) {
        this(mediator, accessTree, new DefaultResourceConfigBuilder(), defaultServiceProviderType, defaultServiceType, defaultResourceType);
    }

    protected ModelConfiguration(Mediator mediator, MutableAccessTree<? extends MutableAccessNode> accessTree, ResourceConfigBuilder defaultResourceConfigBuilder, Class<? extends ServiceProviderImpl> defaultServiceProviderType, Class<? extends ServiceImpl> defaultServiceType, Class<? extends ResourceImpl> defaultResourceType) {
        this.mediator = mediator;
        this.accessTree = accessTree;
        this.defaultServiceProviderType = defaultServiceProviderType;
        this.defaultServiceType = defaultServiceType;
        this.defaultResourceType = defaultResourceType;
        this.resourceConfigCatalogs = new ResourceConfigCatalogCollection();
        ServiceLoader<ResourceConfigCatalog> loader = ServiceLoader.load(ResourceConfigCatalog.class, mediator.getClassLoader());
        for (ResourceConfigCatalog catalog : loader) {
            if (catalog == null) continue;
            this.resourceConfigCatalogs.add(catalog);
        }
        this.resourceConfigType = ResourceConfig.class;
        this.defaultResourceConfigBuilder = defaultResourceConfigBuilder;
    }

    public List<String> getServices(String profile) {
        ArrayList<String> services = new ArrayList<String>();
        if (this.profiles != null) {
            int length;
            String[] stringArray;
            if (profile == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "#ANY_PROFILE#";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "#ANY_PROFILE#";
                stringArray = stringArray3;
                stringArray3[1] = profile;
            }
            String[] profiles = stringArray;
            int n = length = profiles == null ? 0 : profiles.length;
            for (int index = 0; index < length; ++index) {
                List<String> tobeAdded = this.profiles.get(profiles[index]);
                if (tobeAdded == null) continue;
                services.addAll(tobeAdded);
            }
        }
        return Collections.unmodifiableList(services);
    }

    public List<String> getFixedServices(String name) {
        List<String> fixedServices = null;
        if (this.fixed != null && (fixedServices = this.fixed.get(name)) != null) {
            return fixedServices;
        }
        return new ArrayList<String>();
    }

    public MutableAccessTree<? extends MutableAccessNode> getAccessTree() {
        return this.accessTree;
    }

    @Override
    public ModelConfiguration setDefaultResourceType(Class<? extends Resource> defaultResourceType) {
        if (this.defaultResourceConfigBuilder != null) {
            this.defaultResourceConfigBuilder.setDefaultResourceType(defaultResourceType);
        }
        return this;
    }

    @Override
    public ModelConfiguration setDefaultDataType(Class<?> defaultDataType) {
        if (this.defaultResourceConfigBuilder != null) {
            this.defaultResourceConfigBuilder.setDefaultDataType(defaultDataType);
        }
        return this;
    }

    @Override
    public ModelConfiguration setDefaultModifiable(Modifiable defaultModifiable) {
        if (this.defaultResourceConfigBuilder != null) {
            this.defaultResourceConfigBuilder.setDefaultModifiable(defaultModifiable);
        }
        return this;
    }

    @Override
    public ModelConfiguration setDefaultUpdatePolicy(Resource.UpdatePolicy defaultUpdatePolicy) {
        if (this.defaultResourceConfigBuilder != null) {
            this.defaultResourceConfigBuilder.setDefaultUpdatePolicy(defaultUpdatePolicy);
        }
        return this;
    }

    @Override
    public ModelConfiguration setProviderImplementationType(Class<? extends ServiceProviderImpl> serviceProviderType) {
        this.serviceProviderType = serviceProviderType;
        return this;
    }

    @Override
    public Class<? extends ServiceProviderImpl> getProviderImplementationType() {
        if (this.serviceProviderType == null) {
            return this.defaultServiceProviderType;
        }
        return this.serviceProviderType;
    }

    @Override
    public ModelConfiguration setServiceImplmentationType(Class<? extends ServiceImpl> serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @Override
    public Class<? extends ServiceImpl> getServiceImplementationType() {
        if (this.serviceType == null) {
            return this.defaultServiceType;
        }
        return this.serviceType;
    }

    @Override
    public ModelConfiguration setResourceImplementationType(Class<? extends ResourceImpl> resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Override
    public Class<? extends ResourceImpl> getResourceImplementationType() {
        if (this.resourceType == null) {
            return this.defaultResourceType;
        }
        return this.resourceType;
    }

    public ModelConfiguration addResourceConfigCatalog(ResourceConfigCatalog resourceConfigCatalog) {
        if (resourceConfigCatalog != null) {
            this.resourceConfigCatalogs.add(resourceConfigCatalog);
        }
        return this;
    }

    public ResourceDescriptor getResourceDescriptor() {
        ResourceDescriptor descriptor = new ResourceDescriptor();
        descriptor.withResourceConfigType(this.getResourceConfigType());
        descriptor.withResourceImplementationType(this.getResourceImplementationType());
        return descriptor;
    }

    public ResourceConfig getResourceConfig(ResourceDescriptor descriptor) {
        return this.resourceConfigCatalogs.getResourceConfig(descriptor);
    }

    public ResourceConfig createResourceConfig(ResourceDescriptor descriptor) {
        Object resourceConfig = this.defaultResourceConfigBuilder.getResourceConfig(descriptor);
        return resourceConfig;
    }

    public List<ResourceConfig> getResourceConfigs(String serviceId) {
        return this.getResourceConfigs("#ANY_PROFILE#", serviceId);
    }

    public List<ResourceConfig> getResourceConfigs(String profile, String serviceId) {
        ArrayList<ResourceConfig> configs = new ArrayList<ResourceConfig>();
        Iterator<ResourceConfigCatalog> iterator = this.resourceConfigCatalogs.iterator();
        while (iterator.hasNext()) {
            configs.addAll(iterator.next().getResourceConfigs(profile, serviceId));
        }
        return configs;
    }

    public ResourceConfig getDefaultResourceConfig(String profile, String serviceName) {
        ResourceConfig config = null;
        Iterator<ResourceConfigCatalog> iterator = this.resourceConfigCatalogs.iterator();
        while (iterator.hasNext() && (config = (ResourceConfig)iterator.next().getDefaultResourceConfig(profile, serviceName)) == null) {
        }
        return config;
    }

    public ResourceConfig getDefaultResourceConfig(String serviceName) {
        return this.getDefaultResourceConfig("#ANY_PROFILE#", serviceName);
    }

    public void setResourceConfigType(Class<? extends ResourceConfig> resourceConfigType) {
        this.resourceConfigType = resourceConfigType;
    }

    public Class<? extends ResourceConfig> getResourceConfigType() {
        return this.resourceConfigType;
    }

    public <C extends ModelConfiguration, I extends ModelInstance<C>> void setModelInstanceType(Class<I> modelInstanceType) {
        this.modelInstanceType = modelInstanceType;
    }

    public <C extends ModelConfiguration, I extends ModelInstance<C>> Class<I> getModelInstanceType() {
        return this.modelInstanceType;
    }

    public List<String> getObserved() {
        if (this.observed != null) {
            return Collections.unmodifiableList(this.observed);
        }
        return Collections.emptyList();
    }

    public void setObserved(List<String> observed) {
        this.observed = observed != null ? Collections.unmodifiableList(observed) : Collections.emptyList();
    }

    @Override
    public ModelConfiguration setResourceBuildPolicy(byte buildPolicy) {
        this.resourceBuildPolicy = buildPolicy;
        return this;
    }

    @Override
    public byte getResourceBuildPolicy() {
        return this.resourceBuildPolicy;
    }

    @Override
    public ModelConfiguration setServiceBuildPolicy(byte buildPolicy) {
        this.serviceBuildPolicy = buildPolicy;
        return this;
    }

    @Override
    public byte getServiceBuildPolicy() {
        return this.serviceBuildPolicy;
    }

    @Override
    public boolean getStartAtInitializationTime() {
        return this.startAtInitializationTime;
    }

    @Override
    public ModelConfiguration setStartAtInitializationTime(boolean startAtInitializationTime) {
        this.startAtInitializationTime = startAtInitializationTime;
        return this;
    }

    @Override
    public List<MethodAccessibility> getAccessibleMethods(String path, AccessLevelOption accessLevelOption) {
        List<MethodAccessibility> list = ((MutableAccessNode)this.accessTree.getRoot()).get(path).getAccessibleMethods(accessLevelOption);
        return list;
    }

    @Override
    public AccessLevelOption getAuthenticatedAccessLevelOption(final String path, final String publicKey) {
        return AccessController.doPrivileged(new PrivilegedAction<AccessLevelOption>(){

            @Override
            public AccessLevelOption run() {
                return (AccessLevelOption)((Object)ModelConfiguration.this.mediator.callService(AuthorizationService.class, (Executable)new Executable<AuthorizationService, AccessLevelOption>(){

                    public AccessLevelOption execute(AuthorizationService service) throws Exception {
                        return service.getAuthenticatedAccessLevelOption(path, publicKey);
                    }
                }));
            }
        });
    }
}

