/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.sensinact.gateway.core.Session;
import org.eclipse.sensinact.gateway.core.SessionKey;

public class Sessions {
    private static final int DEFAULT_INITIAL_CAPACITY = 128;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int ALTERNATIVE_HASHING_THRESHOLD_DEFAULT = Integer.MAX_VALUE;
    private Entry[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<Object> queue = new ReferenceQueue();

    private static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1 == o2 || o1.equals(o2);
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public Sessions() {
        int capacity;
        for (capacity = 1; capacity < 128; capacity <<= 1) {
        }
        this.table = new Entry[capacity];
        this.loadFactor = 0.75f;
        this.threshold = (int)((float)capacity * this.loadFactor);
    }

    int hash(Object k) {
        int h = k.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expungeStaleEntries() {
        Reference<Object> x;
        while ((x = this.queue.poll()) != null) {
            ReferenceQueue<Object> referenceQueue = this.queue;
            synchronized (referenceQueue) {
                Entry prev;
                Entry e = (Entry)x;
                int i = Sessions.indexFor(e.hash, this.table.length);
                Entry p = prev = this.table[i];
                while (p != null) {
                    Entry next = p.next;
                    if (p == e) {
                        if (prev == e) {
                            this.table[i] = next;
                        } else {
                            prev.next = next;
                        }
                        e.value = null;
                        --this.size;
                        break;
                    }
                    prev = p;
                    p = next;
                }
            }
        }
    }

    private Entry[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    private int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public SessionKey get(Object key) {
        Object k = key;
        int h = this.hash(k);
        Entry[] tab = this.getTable();
        int index = Sessions.indexFor(h, tab.length);
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == h && (KeyExtractor.class == k.getClass() && Sessions.eq(k, e.getValue()) || Session.class == k.getClass() && Sessions.eq(k, e.getKey()))) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    private Session getSession(KeyExtractor k) {
        int h = this.hash(k);
        Entry[] tab = this.getTable();
        int index = Sessions.indexFor(h, tab.length);
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == h && Sessions.eq(k, e.getValue())) {
                return e.getKey();
            }
            e = e.next;
        }
        return null;
    }

    public Session getSessionFromToken(String token) {
        if (token == null) {
            return null;
        }
        return this.getSession(new KeyExtractor<KeyExtractorType>(KeyExtractorType.TOKEN, token));
    }

    public Session getSessionFromPublicKey(String publicKey) {
        if (publicKey == null) {
            return null;
        }
        return this.getSession(new KeyExtractor<KeyExtractorType>(KeyExtractorType.PUBLIC, publicKey));
    }

    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    Entry getEntry(Object key) {
        Object k = key;
        int h = this.hash(k);
        Entry[] tab = this.getTable();
        int index = Sessions.indexFor(h, tab.length);
        Entry e = tab[index];
        while (!(e == null || e.hash == h && (KeyExtractor.class == k.getClass() && Sessions.eq(k, e.getValue()) || Session.class == k.getClass() && Sessions.eq(k, e.getKey())))) {
            e = e.next;
        }
        return e;
    }

    public void put(SessionKey key, Session value) {
        int length;
        if (key == null) {
            return;
        }
        KeyExtractorType[] values = KeyExtractorType.values();
        int n = length = values == null ? 0 : values.length;
        for (int index = 0; index < length; ++index) {
            int h = 0;
            boolean found = false;
            KeyExtractorType type = values[index];
            switch (type) {
                case PUBLIC: {
                    h = this.hash(key.getPublicKey());
                    break;
                }
                case TOKEN: {
                    h = this.hash(key.getToken());
                    break;
                }
                default: {
                    h = this.hash(key);
                }
            }
            Entry[] tab = this.getTable();
            int i = Sessions.indexFor(h, tab.length);
            Entry e = tab[i];
            while (e != null) {
                if (h == e.hash && Sessions.eq(value.getSessionId(), e.getKey().getSessionId())) {
                    e.value = key;
                    found = true;
                    break;
                }
                e = e.next;
            }
            if (found) {
                found = false;
                continue;
            }
            e = tab[i];
            tab[i] = new Entry(value, key, this.queue, h, e);
            if (++this.size < this.threshold) continue;
            this.resize(tab.length * 2);
        }
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.getTable();
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(oldTable, newTable);
        this.table = newTable;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)newCapacity * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(newTable, oldTable);
            this.table = oldTable;
        }
    }

    private void transfer(Entry[] src, Entry[] dest) {
        for (int j = 0; j < src.length; ++j) {
            Entry e = src[j];
            src[j] = null;
            while (e != null) {
                Entry next = e.next;
                Object key = e.get();
                if (key == null) {
                    e.next = null;
                    e.value = null;
                    --this.size;
                } else {
                    int i = Sessions.indexFor(e.hash, dest.length);
                    e.next = dest[i];
                    dest[i] = e;
                }
                e = next;
            }
        }
    }

    public void remove(Session key) {
        int length;
        SessionKey skey = null;
        if (key == null || (skey = this.get(key)) == null) {
            return;
        }
        KeyExtractorType[] values = KeyExtractorType.values();
        int n = length = values == null ? 0 : values.length;
        block4: for (int index = 0; index < length; ++index) {
            Entry prev;
            int h = 0;
            KeyExtractorType type = values[index];
            switch (type) {
                case PUBLIC: {
                    h = this.hash(skey.getPublicKey());
                    break;
                }
                case TOKEN: {
                    h = this.hash(skey.getToken());
                    break;
                }
                default: {
                    h = this.hash(key);
                }
            }
            Entry[] tab = this.getTable();
            int i = Sessions.indexFor(h, tab.length);
            Entry e = prev = tab[i];
            while (e != null) {
                Entry next = e.next;
                if (h == e.hash && Sessions.eq(key, e.get())) {
                    --this.size;
                    if (prev == e) {
                        tab[i] = next;
                        continue block4;
                    }
                    prev.next = next;
                    continue block4;
                }
                prev = e;
                e = next;
            }
        }
    }

    public void clear() {
        while (this.queue.poll() != null) {
        }
        Arrays.fill(this.table, null);
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    private static class Entry
    extends WeakReference<Object>
    implements Map.Entry<Session, SessionKey> {
        SessionKey value;
        int hash;
        Entry next;

        Entry(Object key, SessionKey value, ReferenceQueue<Object> queue, int hash, Entry next) {
            super(key, queue);
            this.value = value;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public Session getKey() {
            return (Session)this.get();
        }

        @Override
        public SessionKey getValue() {
            return this.value;
        }

        @Override
        public SessionKey setValue(SessionKey newValue) {
            SessionKey oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            SessionKey v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Session k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            Session k = this.getKey();
            SessionKey v = this.getValue();
            return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    public static class KeyExtractor<E extends Enum<KeyExtractorType>> {
        private E e;
        private Object v;

        public KeyExtractor(E e, Object v) {
            this.e = e;
            this.v = v;
        }

        public boolean equals(Object o) {
            if (this.v == null || o == null || SessionKey.class != o.getClass()) {
                return false;
            }
            SessionKey k = (SessionKey)o;
            switch ((KeyExtractorType)((Object)this.e)) {
                case PUBLIC: {
                    return this.v.equals(k.getPublicKey());
                }
                case TOKEN: {
                    return this.v.equals(k.getToken());
                }
            }
            return false;
        }

        public int hashCode() {
            return this.v.hashCode();
        }
    }

    public static enum KeyExtractorType {
        TOKEN,
        PUBLIC;

    }

    public static interface SessionObserver {
        public void disappearing(String var1);
    }
}

