/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.message.whiteboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.ConstraintFactory;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.core.Core;
import org.eclipse.sensinact.gateway.core.message.AbstractMidAgentCallback;
import org.eclipse.sensinact.gateway.core.message.AgentRelay;
import org.eclipse.sensinact.gateway.core.message.MessageFilterDefinition;
import org.eclipse.sensinact.gateway.core.message.MidCallbackException;
import org.eclipse.sensinact.gateway.core.message.SnaErrorMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaFilter;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.message.SnaRemoteMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaResponseMessage;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessageImpl;
import org.eclipse.sensinact.gateway.core.message.annotation.Filter;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class AgentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AgentFactory.class);
    private Mediator mediator;
    private String appearingKey;
    private String disappearingKey;
    private Map<String, AgentCallback> registrations = Collections.synchronizedMap(new HashMap());
    private final AtomicBoolean running = new AtomicBoolean(false);

    private static final String ID_GENERATOR(AgentRelay agentRelay) {
        String ari = null;
        ari = agentRelay.getRelayIdentifier() == null ? "ARI_" + System.currentTimeMillis() + agentRelay.hashCode() : agentRelay.getRelayIdentifier();
        return ari;
    }

    @Activate
    public void activate(ComponentContext context) {
        this.mediator = new Mediator(context.getBundleContext());
        if (this.running.get()) {
            return;
        }
        this.running.set(true);
        this.attachAll();
        this.appearingKey = this.mediator.attachOnServiceAppearing(AgentRelay.class, (String)null, (Executable)new Executable<AgentRelay, Void>(){

            public Void execute(AgentRelay agentRelay) throws Exception {
                AgentFactory.this.attach(agentRelay);
                return null;
            }
        });
        this.disappearingKey = this.mediator.attachOnServiceDisappearing(AgentRelay.class, (String)null, (Executable)new Executable<AgentRelay, Void>(){

            public Void execute(AgentRelay agentRelay) throws Exception {
                AgentFactory.this.detach(agentRelay);
                return null;
            }
        });
    }

    @Deactivate
    public void deactivate() {
        if (!this.running.get()) {
            return;
        }
        this.running.set(false);
        this.mediator.detachOnServiceAppearing(AgentRelay.class, (String)null, this.appearingKey);
        this.mediator.detachOnServiceDisappearing(AgentRelay.class, (String)null, this.disappearingKey);
        this.detachAll();
    }

    public void detachAll() {
        this.mediator.callServices(AgentRelay.class, (Executable)new Executable<AgentRelay, Void>(){

            public Void execute(AgentRelay agentRelay) throws Exception {
                AgentFactory.this.detach(agentRelay);
                return null;
            }
        });
    }

    public void attachAll() {
        this.mediator.callServices(AgentRelay.class, (Executable)new Executable<AgentRelay, Void>(){

            public Void execute(AgentRelay agentRelay) throws Exception {
                AgentFactory.this.attach(agentRelay);
                return null;
            }
        });
    }

    public final void attach(AgentRelay agentRelay) {
        SnaFilter filter;
        if (agentRelay == null || !this.running.get()) {
            return;
        }
        String id = "relay_" + this.hashCode() + agentRelay.hashCode();
        if (this.registrations.containsKey(id)) {
            LOG.error("An AgentRelay is already registered with ID '%s'", (Object)id);
            return;
        }
        AgentRelayWrapper wrapper = new AgentRelayWrapper(agentRelay);
        boolean defined = false;
        boolean isPattern = wrapper.isPattern();
        boolean isComplement = wrapper.isComplement();
        String sender = wrapper.sender();
        if (sender == null) {
            sender = "(/[^/]+)+";
            isPattern = true;
        } else {
            defined = true;
        }
        List<Constraint> constraints = wrapper.conditions();
        if (constraints == null) {
            constraints = new ArrayList<Constraint>();
        } else {
            defined = true;
        }
        SnaMessage.Type[] handled = wrapper.handledTypes();
        if (handled == null) {
            handled = SnaMessage.Type.values();
        } else {
            defined = true;
        }
        if (defined) {
            filter = new SnaFilter(this.mediator, sender, isPattern, isComplement);
            for (Constraint cn : constraints) {
                filter.addCondition(cn);
            }
            filter.addHandledType(handled);
        } else {
            filter = null;
        }
        final AgentCallback callback = new AgentCallback(wrapper);
        if (wrapper.lifetime() > 0L) {
            callback.setTimeout(System.currentTimeMillis() + wrapper.lifetime());
        }
        this.mediator.callService(Core.class, (Executable)new Executable<Core, String>(){

            public String execute(Core core) throws Exception {
                return core.registerAgent(AgentFactory.this.mediator, callback, filter);
            }
        });
        this.registrations.put(id, callback);
    }

    public final void detach(AgentRelay agentRelay) {
        if (agentRelay == null) {
            return;
        }
        String id = "relay_" + this.hashCode() + agentRelay.hashCode();
        AgentCallback callback = this.registrations.remove(id);
        if (callback != null) {
            try {
                callback.stop();
                LOG.info("Agent callback '%s' unregistered", (Object)id);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            callback = null;
        }
    }

    private final class AgentRelayWrapper
    implements AgentRelay,
    MessageFilterDefinition {
        private AgentRelay agentRelay;
        private MessageFilterDefinition filterDefinition;

        protected AgentRelayWrapper(AgentRelay agentRelay) {
            Filter filter;
            this.agentRelay = agentRelay;
            this.filterDefinition = this.agentRelay instanceof MessageFilterDefinition ? (MessageFilterDefinition)((Object)this.agentRelay) : ((filter = this.agentRelay.getClass().getAnnotation(Filter.class)) == null ? new EmptyFilterDefinition() : new AnnotationFilterDefinition(filter));
        }

        @Override
        public boolean propagate() {
            return this.agentRelay.propagate();
        }

        @Override
        public void doHandle(SnaLifecycleMessageImpl message) throws MidCallbackException {
            this.agentRelay.doHandle(message);
        }

        @Override
        public void doHandle(SnaUpdateMessageImpl message) throws MidCallbackException {
            this.agentRelay.doHandle(message);
        }

        @Override
        public void doHandle(SnaRemoteMessageImpl message) throws MidCallbackException {
            this.agentRelay.doHandle(message);
        }

        @Override
        public void doHandle(SnaErrorMessageImpl message) throws MidCallbackException {
            this.agentRelay.doHandle(message);
        }

        @Override
        public void doHandle(SnaResponseMessage<?, ?> message) throws MidCallbackException {
            this.agentRelay.doHandle(message);
        }

        @Override
        public String getRelayIdentifier() {
            return this.agentRelay.getRelayIdentifier();
        }

        @Override
        public long lifetime() {
            return this.agentRelay.lifetime();
        }

        @Override
        public SnaMessage.Type[] handledTypes() {
            return this.filterDefinition.handledTypes();
        }

        @Override
        public List<Constraint> conditions() {
            return this.filterDefinition.conditions();
        }

        @Override
        public String sender() {
            return this.filterDefinition.sender();
        }

        @Override
        public boolean isPattern() {
            return this.filterDefinition.isPattern();
        }

        @Override
        public boolean isComplement() {
            return this.filterDefinition.isComplement();
        }
    }

    private final class AgentCallback
    extends AbstractMidAgentCallback {
        AgentRelay agentRelay;

        protected AgentCallback(AgentRelay agentRelay) {
            super(true, true, AgentFactory.ID_GENERATOR(agentRelay));
            this.agentRelay = agentRelay;
        }

        @Override
        public boolean propagate() {
            return this.agentRelay.propagate();
        }

        @Override
        public void doHandle(SnaLifecycleMessageImpl message) throws MidCallbackException {
            this.agentRelay.doHandle(message);
        }

        @Override
        public void doHandle(SnaUpdateMessageImpl message) throws MidCallbackException {
            this.agentRelay.doHandle(message);
        }

        @Override
        public void doHandle(SnaRemoteMessageImpl message) throws MidCallbackException {
            this.agentRelay.doHandle(message);
        }

        @Override
        public void doHandle(SnaErrorMessageImpl message) throws MidCallbackException {
            this.agentRelay.doHandle(message);
        }

        @Override
        public void doHandle(SnaResponseMessage<?, ?> message) throws MidCallbackException {
            this.agentRelay.doHandle(message);
        }

        @Override
        protected void setTimeout(long timeout) {
            super.setTimeout(timeout);
        }
    }

    private final class AnnotationFilterDefinition
    implements MessageFilterDefinition {
        private Filter filter;

        AnnotationFilterDefinition(Filter filter) {
            this.filter = filter;
        }

        @Override
        public SnaMessage.Type[] handledTypes() {
            SnaMessage.Type[] arr = this.filter.handled();
            if (arr == null || arr.length == 0) {
                arr = SnaMessage.Type.values();
            }
            return arr;
        }

        @Override
        public List<Constraint> conditions() {
            String[] cds = this.filter.conditions();
            if (cds != null && cds.length > 0) {
                ArrayList<Constraint> constraints = new ArrayList<Constraint>();
                ClassLoader cl = AgentFactory.this.mediator.getClassLoader();
                for (String s : cds) {
                    try {
                        JSONObject constraint = new JSONObject(s);
                        constraints.add(ConstraintFactory.Loader.load((ClassLoader)cl, (JSONObject)constraint));
                    }
                    catch (InvalidConstraintDefinitionException | JSONException e) {
                        LOG.error("Unable to read attached constraints", e);
                        constraints.clear();
                        break;
                    }
                }
                if (!constraints.isEmpty()) {
                    return constraints;
                }
            }
            return null;
        }

        @Override
        public String sender() {
            return this.filter.sender();
        }

        @Override
        public boolean isPattern() {
            return this.filter.isPattern();
        }

        @Override
        public boolean isComplement() {
            return this.filter.isComplement();
        }
    }

    private final class EmptyFilterDefinition
    implements MessageFilterDefinition {
        private EmptyFilterDefinition() {
        }

        @Override
        public SnaMessage.Type[] handledTypes() {
            return null;
        }

        @Override
        public List<Constraint> conditions() {
            return null;
        }

        @Override
        public String sender() {
            return null;
        }

        @Override
        public boolean isPattern() {
            return false;
        }

        @Override
        public boolean isComplement() {
            return false;
        }
    }
}

