/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.ErrorHandler;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.ResourceProxy;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethodDescription;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.method.Signature;

public class ServiceAccessMethod
implements AccessMethod {
    private final Mediator mediator;
    protected final String uri;
    private final AccessMethod.Type type;
    private final List<Signature> signatures;
    private ErrorHandler handler;

    public ServiceAccessMethod(Mediator mediator, String uri, AccessMethod.Type type, ErrorHandler handler) {
        this.uri = uri;
        this.type = type;
        this.mediator = mediator;
        this.handler = handler;
        this.signatures = new ArrayList<Signature>();
    }

    protected Signature getSignature(Class<?>[] parameterTypes) {
        for (Signature signature : this.signatures) {
            if (!signature.equals(this.type.name(), parameterTypes == null ? new Class[]{} : parameterTypes)) continue;
            return signature;
        }
        return null;
    }

    protected Signature getSignature(Signature signature) {
        Signature invokerSignature2 = null;
        if (signature != null) {
            for (Signature invokerSignature2 : this.signatures) {
                if (signature == invokerSignature2 || invokerSignature2.equals(signature)) break;
                invokerSignature2 = null;
            }
        }
        return invokerSignature2;
    }

    public void addSignature(Signature signature) {
        if (signature == null || signature.getName().intern() != this.type.name().intern() || this.getSignature(signature) != null) {
            return;
        }
        this.signatures.add(signature);
    }

    public AccessMethodResponse<?> invoke(Object[] parameters) {
        try {
            Resource resource = (Resource)parameters[0];
            Object[] subparameters = this.getParameters(parameters);
            ResourceImpl.ResourceProxyWrapper resourceProxy = (ResourceImpl.ResourceProxyWrapper)Proxy.getInvocationHandler(resource);
            return ((ResourceProxy)resourceProxy.getProxy()).invoke(this.getType().name(), subparameters);
        }
        catch (Throwable e) {
            return AccessMethodResponse.error(this.mediator, this.uri, this.getType(), 500, e.getMessage(), e);
        }
    }

    @Override
    public AccessMethod.Type getType() {
        return this.type;
    }

    public String getName() {
        return this.type.name();
    }

    @Override
    public Set<Signature> getSignatures() {
        return Collections.unmodifiableSet(new HashSet<Signature>(this.signatures));
    }

    @Override
    public int size() {
        return this.signatures.size();
    }

    private final Object[] getParameters(Object[] parameters) {
        int length = parameters.length - 1;
        Object[] subParameters = new Object[length];
        if (length > 0) {
            System.arraycopy(parameters, 1, subParameters, 0, length);
        }
        return subParameters;
    }

    public String getPath() {
        return this.uri;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.handler;
    }

    public AccessMethodDescription getDescription() {
        return new AccessMethodDescription(this);
    }
}

