/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.tools.connector.influxdb;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.sensinact.gateway.tools.connector.influxdb.InfluxDBTagDTO;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Point;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;

public class InfluxDbDatabase {
    private static final long MILLISECOND = 1L;
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long WEEK = 604800000L;
    private static final ThreadLocal<SimpleDateFormatProvider> THREAD_LOCAL_FORMATS = new ThreadLocal<SimpleDateFormatProvider>(){

        @Override
        protected SimpleDateFormatProvider initialValue() {
            return new SimpleDateFormatProvider(){

                @Override
                public Iterator<SimpleDateFormat> iterator() {
                    return Arrays.asList(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'")).iterator();
                }
            };
        }
    };
    private InfluxDB influxDB;
    private String database;
    private final ZoneOffset offset;

    public InfluxDbDatabase(InfluxDB influxDB, String database) {
        this(influxDB, database, "autogen");
    }

    public InfluxDbDatabase(InfluxDB influxDB, String database, String retention) {
        this.influxDB = influxDB;
        this.database = database;
        this.offset = ZoneOffset.systemDefault().getRules().getOffset(Instant.now());
        influxDB.setDatabase(database);
        influxDB.setRetentionPolicy(retention);
    }

    public void add(String measurement, Dictionary<String, String> tags, Object value) {
        this.add(measurement, tags, null, value, System.currentTimeMillis());
    }

    public void add(String measurement, Dictionary<String, String> tags, Dictionary<String, Object> fields, Object value) {
        this.add(measurement, tags, fields, value, System.currentTimeMillis());
    }

    public void add(String measurement, Dictionary<String, String> tags, Dictionary<String, Object> fields, Object value, long timestamp) {
        Point point = null;
        Point.Builder builder = Point.measurement(measurement);
        if (tags != null && !tags.isEmpty()) {
            for (String key : Collections.list(tags.keys())) {
                builder.tag(key, tags.get(key));
            }
        }
        builder.time(timestamp, TimeUnit.MILLISECONDS);
        if (fields != null && !fields.isEmpty()) {
            for (String key : Collections.list(fields.keys())) {
                this.addField(builder, key, fields.get(key));
            }
        }
        this.addField(builder, "value", value);
        point = builder.build();
        this.influxDB.write(point);
        this.influxDB.flush();
    }

    private void addField(Point.Builder builder, String key, Object value) {
        if (value == null) {
            return;
        }
        if (value.getClass().isPrimitive()) {
            switch (value.getClass().getName()) {
                case "byte": {
                    builder.addField(key, (Byte)value);
                    break;
                }
                case "short": {
                    builder.addField(key, (Short)value);
                    break;
                }
                case "int": {
                    builder.addField(key, (Integer)value);
                    break;
                }
                case "long": {
                    builder.addField(key, (Long)value);
                    break;
                }
                case "float": {
                    builder.addField(key, Float.valueOf(((Float)value).floatValue()));
                    break;
                }
                case "double": {
                    builder.addField(key, (Double)value);
                    break;
                }
                case "char": {
                    builder.addField(key, new String(new char[]{((Character)value).charValue()}));
                    break;
                }
                case "boolean": {
                    builder.addField(key, (Boolean)value);
                }
            }
        } else if (value instanceof String) {
            builder.addField(key, (String)value);
        } else if (value instanceof Number) {
            switch (value.getClass().getName()) {
                case "java.lang.Byte": {
                    builder.addField(key, (Byte)value);
                    break;
                }
                case "java.lang.Short": {
                    builder.addField(key, (Short)value);
                    break;
                }
                case "java.lang.Integer": {
                    builder.addField(key, (Integer)value);
                    break;
                }
                case "java.lang.Long": {
                    builder.addField(key, (Long)value);
                    break;
                }
                case "java.lang.Float": {
                    builder.addField(key, (Float)value);
                    break;
                }
                case "java.lang.Double": {
                    builder.addField(key, (Double)value);
                    break;
                }
                case "java.lang.Character": {
                    builder.addField(key, new String(new char[]{((Character)value).charValue()}));
                    break;
                }
                case "java.lang.Boolean": {
                    builder.addField(key, new String(new char[]{((Character)value).charValue()}));
                }
            }
        } else if (value instanceof Enum) {
            builder.addField(key, ((Enum)value).name());
        } else {
            builder.addField(key, String.valueOf(value));
        }
    }

    private String getTimeWindow(long timeWindow) {
        long measure;
        int pos;
        if (timeWindow <= 1L) {
            return "";
        }
        long[] measures = new long[]{604800000L, 86400000L, 3600000L, 60000L, 1000L, 1L};
        long d = 0L;
        for (pos = 0; pos < measures.length && (timeWindow <= (measure = measures[pos]) || (d = timeWindow / measure) * measure != timeWindow); ++pos) {
            d = 0L;
        }
        switch (pos) {
            case 0: {
                return String.format(" group by time(%sw)", d);
            }
            case 1: {
                return String.format(" group by time(%sd)", d);
            }
            case 2: {
                return String.format(" group by time(%sh)", d);
            }
            case 3: {
                return String.format(" group by time(%sm)", d);
            }
            case 4: {
                return String.format(" group by time(%ss)", d);
            }
            case 5: {
                return String.format(" group by time(%sms)", d);
            }
        }
        return "";
    }

    private String getSelectFunction(String column, String function) {
        String select = null;
        if (column == null || column.trim().length() == 0) {
            return null;
        }
        if (function == null) {
            return column;
        }
        switch (function) {
            case "avg": 
            case "mean": {
                select = String.format("MEAN(%s)", column);
                break;
            }
            case "count": {
                select = String.format("COUNT(%s)", column);
                break;
            }
            case "countDistinct": {
                select = String.format("COUNT(DISTINCT(%s))", column);
                break;
            }
            case "distinct": {
                select = String.format("DISTINCT(%s)", column);
                break;
            }
            case "max": {
                select = String.format("MAX(%s)", column);
                break;
            }
            case "median": {
                select = String.format("MEDIAN(%s)", column);
                break;
            }
            case "min": {
                select = String.format("MIN(%s)", column);
                break;
            }
            case "sum_square": 
            case "sqsum": {
                select = String.format("SQRT(SUM(%s))", column, column);
                break;
            }
            case "sum": {
                select = String.format("SUM(%s)", column);
                break;
            }
            default: {
                select = column;
            }
        }
        return select;
    }

    private String buildWhereClause(List<InfluxDBTagDTO> tags) {
        String where = null;
        if (tags == null || tags.isEmpty()) {
            where = "";
            return where;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" WHERE ");
        for (int i = 0; i < tags.size(); ++i) {
            InfluxDBTagDTO t = tags.get(i);
            if (i > 0) {
                builder.append(" AND ");
            }
            builder.append(t.name);
            builder.append(t.pattern ? "=~" : "=");
            builder.append(t.pattern ? " " : "'");
            builder.append(t.value);
            builder.append(t.pattern ? " " : "'");
        }
        where = builder.toString();
        return where;
    }

    public QueryResult getResult(String measurement, List<InfluxDBTagDTO> tags, List<String> columns) {
        String select = null;
        select = columns == null || columns.isEmpty() ? "* " : columns.stream().collect(StringBuilder::new, (b, s) -> {
            b.append((String)s);
            b.append(",");
        }, (h, t) -> h.append(t.toString())).toString();
        select = select.substring(0, select.length() - 1);
        String from = String.format(" FROM %s ", measurement);
        String where = this.buildWhereClause(tags);
        Query query = new Query(String.format("SELECT %s%s%s", select, from, where), this.database);
        QueryResult result = this.influxDB.query(query);
        return result;
    }

    public QueryResult getResult(String measurement, List<InfluxDBTagDTO> tags, String column, String function, long timeWindow) {
        String select = this.getSelectFunction(column, function);
        if (select == null) {
            return null;
        }
        String from = String.format(" FROM %s ", measurement);
        String where = this.buildWhereClause(tags);
        String window = this.getTimeWindow(timeWindow);
        Query query = new Query(String.format("SELECT %s%s%s%s", select, from, where, window), this.database);
        QueryResult result = this.influxDB.query(query);
        return result;
    }

    public QueryResult getResult(String measurement, List<InfluxDBTagDTO> tags, List<String> columns, LocalDateTime start) {
        if (start == null) {
            return this.getResult(measurement, tags, columns);
        }
        String select = null;
        select = columns == null || columns.isEmpty() ? "* " : columns.stream().collect(StringBuilder::new, (b, s) -> {
            b.append((String)s);
            b.append(",");
        }, (h, t) -> h.append(t.toString())).toString();
        select = select.substring(0, select.length() - 1);
        String from = String.format(" FROM %s ", measurement);
        String where = this.buildWhereClause(tags);
        SimpleDateFormatProvider formatProvider = THREAD_LOCAL_FORMATS.get();
        SimpleDateFormat df = formatProvider.iterator().next();
        String startDate = df.format(new Date(start.toInstant(this.offset).toEpochMilli()));
        THREAD_LOCAL_FORMATS.remove();
        if (where.length() == 0) {
            where = String.format(" WHERE time > '%s'", startDate);
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append(where);
            builder.append(String.format(" AND time > '%s'", startDate));
            where = builder.toString();
        }
        Query query = new Query(String.format("SELECT %s%s%s", select, from, where), this.database);
        QueryResult result = this.influxDB.query(query);
        return result;
    }

    public QueryResult getResult(String measurement, List<InfluxDBTagDTO> tags, String column, String function, long timeWindow, LocalDateTime start) {
        if (start == null) {
            return this.getResult(measurement, tags, column, function, timeWindow);
        }
        String select = this.getSelectFunction(column, function);
        if (select == null) {
            return null;
        }
        String from = String.format(" FROM %s ", measurement);
        String where = this.buildWhereClause(tags);
        SimpleDateFormatProvider formatProvider = THREAD_LOCAL_FORMATS.get();
        SimpleDateFormat df = formatProvider.iterator().next();
        String startDate = df.format(new Date(start.toInstant(this.offset).toEpochMilli()));
        THREAD_LOCAL_FORMATS.remove();
        if (where.length() == 0) {
            where = String.format(" WHERE time > '%s'", startDate);
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append(where);
            builder.append(String.format(" AND time > '%s'", startDate));
            where = builder.toString();
        }
        String window = this.getTimeWindow(timeWindow);
        Query query = new Query(String.format("SELECT %s%s%s%s", select, from, where, window), this.database);
        QueryResult result = this.influxDB.query(query);
        return result;
    }

    public QueryResult getResult(String measurement, List<InfluxDBTagDTO> tags, List<String> columns, LocalDateTime start, LocalDateTime end) {
        if (end == null) {
            return this.getResult(measurement, tags, columns, start);
        }
        String select = null;
        select = columns == null || columns.isEmpty() ? "* " : columns.stream().collect(StringBuilder::new, (b, s) -> {
            b.append((String)s);
            b.append(",");
        }, (h, t) -> h.append(t.toString())).toString();
        select = select.substring(0, select.length() - 1);
        SimpleDateFormatProvider formatProvider = THREAD_LOCAL_FORMATS.get();
        SimpleDateFormat df = formatProvider.iterator().next();
        String startDate = null;
        String endDate = null;
        startDate = df.format(new Date(start.toInstant(this.offset).toEpochMilli()));
        endDate = df.format(new Date(end.toInstant(this.offset).toEpochMilli()));
        THREAD_LOCAL_FORMATS.remove();
        String from = String.format(" FROM %s ", measurement);
        String where = this.buildWhereClause(tags);
        if (where.length() == 0) {
            where = String.format(" WHERE time > '%s' AND time < '%s'", startDate, endDate);
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append(where);
            builder.append(String.format(" AND time > '%s' AND time < '%s'", startDate, endDate));
            where = builder.toString();
        }
        Query query = new Query(String.format("SELECT %s%s%s", select, from, where), this.database);
        QueryResult result = this.influxDB.query(query);
        return result;
    }

    public QueryResult getResult(String measurement, List<InfluxDBTagDTO> tags, String column, String function, long timeWindow, LocalDateTime start, LocalDateTime end) {
        if (end == null) {
            return this.getResult(measurement, tags, column, function, timeWindow, start);
        }
        String select = this.getSelectFunction(column, function);
        if (select == null) {
            return null;
        }
        String from = String.format(" FROM %s ", measurement);
        SimpleDateFormatProvider formatProvider = THREAD_LOCAL_FORMATS.get();
        SimpleDateFormat df = formatProvider.iterator().next();
        String startDate = df.format(new Date(start.toInstant(this.offset).toEpochMilli()));
        String endDate = df.format(new Date(end.toInstant(this.offset).toEpochMilli()));
        THREAD_LOCAL_FORMATS.remove();
        String where = this.buildWhereClause(tags);
        if (where.length() == 0) {
            where = String.format(" WHERE time > '%s' AND time < '%s'", startDate, endDate);
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append(where);
            builder.append(String.format(" AND time > '%s' AND time < '%s'", startDate, endDate));
            where = builder.toString();
        }
        String window = this.getTimeWindow(timeWindow);
        Query query = new Query(String.format("SELECT %s%s%s%s", select, from, where, window), this.database);
        QueryResult result = this.influxDB.query(query);
        return result;
    }

    private static interface SimpleDateFormatProvider {
        public Iterator<SimpleDateFormat> iterator();
    }
}

