/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.agent.http.onem2m.internal;

import java.io.IOException;
import org.eclipse.sensinact.gateway.agent.http.onem2m.internal.OneM2MModel;
import org.eclipse.sensinact.gateway.core.message.AbstractMidAgentCallback;
import org.eclipse.sensinact.gateway.core.message.SnaErrorMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessage;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaResponseMessage;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessage;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessageImpl;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnaEventOneM2MHttpHandler
extends AbstractMidAgentCallback {
    private static Logger LOG = LoggerFactory.getLogger((String)SnaEventOneM2MHttpHandler.class.getCanonicalName());
    private final String cseBase;

    public SnaEventOneM2MHttpHandler(String cseBase) throws IOException {
        this.cseBase = cseBase;
    }

    public void doHandle(SnaUpdateMessageImpl event) {
        LOG.debug("Received event {}", (Object)event.getJSON().toString());
        OneM2MModel model = OneM2MModel.getInstance(this.cseBase);
        JSONObject eventJson = new JSONObject(event.getJSON()).getJSONObject("notification");
        String[] eventPathSplit = event.getPath().split("/");
        String provider = eventPathSplit[1];
        String service = eventPathSplit[2];
        String resource = eventPathSplit[3];
        LOG.debug("Extracted provider '{}' service '{}' and resource '{}' from message", new Object[]{provider, service, resource});
        switch ((SnaUpdateMessage.Update)event.getType()) {
            case ATTRIBUTE_VALUE_UPDATED: {
                Object value = eventJson.get("value");
                LOG.debug("Extracted value '{}' from message", (Object)value.toString());
                if (event.getPath().endsWith("/admin/location/value")) {
                    LOG.debug("Location update message");
                    String[] locs = String.valueOf(value).split(":");
                    if (locs.length != 2) {
                        return;
                    }
                    try {
                        Double latitude = Double.parseDouble(locs[0]);
                        LOG.debug("Extracted latitude '{}'", (Object)latitude);
                        Double longitude = Double.parseDouble(locs[1]);
                        LOG.debug("Extracted longitude '{}'", (Object)longitude);
                        model.integrateReading(provider, "location", "latitude", latitude.toString());
                        model.integrateReading(provider, "location", "longitude", longitude.toString());
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Failed to integrate value", (Throwable)e);
                    }
                    break;
                }
                LOG.debug("Value update message to value '{}'", (Object)value.toString());
                try {
                    model.integrateReading(provider, service, resource, value.toString());
                }
                catch (NumberFormatException e) {
                    LOG.error("Failed to integrate value '{}'", (Object)value.toString(), (Object)e);
                }
                break;
            }
            default: {
                return;
            }
        }
    }

    public void doHandle(SnaLifecycleMessageImpl event) {
        LOG.debug("Received Lifecycle event {}", (Object)event.getJSON().toString());
        JSONObject eventJson = new JSONObject(event.getJSON());
        LOG.debug("Evaluating event of the type {}", (Object)event.getType());
        switch ((SnaLifecycleMessage.Lifecycle)event.getType()) {
            case RESOURCE_DISAPPEARING: {
                LOG.debug("Provider disappearing{}", (Object)event.getJSON().toString());
                String provider = event.getPath().split("/")[1];
                String service = event.getPath().split("/")[2];
                String resource = event.getPath().split("/")[3];
                OneM2MModel.getInstance(this.cseBase).removeProvider(provider);
            }
        }
    }

    public void stop() {
    }

    public void doHandle(SnaErrorMessageImpl event) {
    }

    public void doHandle(SnaResponseMessage<?, ?> event) {
    }
}

