/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.exception.MessageInvalidSmartTopicException;

public class SmartTopicInterpolator {
    private final String PROVIDER_TAG = "{provider}";
    private final String SERVICE_TAG = "{service}";
    private final String RESOURCE_TAG = "{resource}";
    private final String VALUE_TAG = "{value}";
    private final String MQTT_TAG = "+";
    private String smartTopic = "";
    private Pattern pattern;

    public SmartTopicInterpolator(String smartTopic) {
        this.smartTopic = smartTopic;
    }

    public String getTopic() {
        StringBuffer buffer = new StringBuffer();
        Integer counter = 0;
        for (String partTopic : this.smartTopic.split("/")) {
            if (counter != 0) {
                buffer.append("/");
            }
            if (partTopic.contains("{provider}") || partTopic.contains("{service}") || partTopic.contains("{resource}") || partTopic.contains("{value}")) {
                buffer.append("+");
            } else {
                buffer.append(partTopic);
            }
            Integer n = counter;
            counter = counter + 1;
        }
        return buffer.toString();
    }

    public String getRegex() {
        StringBuffer buffer = new StringBuffer();
        String[] partTopics = this.smartTopic.split("/");
        Integer counter = 0;
        for (String partTopic : partTopics) {
            if (counter != 0) {
                buffer.append("/");
            }
            if (partTopic.contains("{provider}")) {
                buffer.append(partTopic.replace("{provider}", "(?<provider>.*)"));
            } else if (partTopic.contains("{service}")) {
                buffer.append(partTopic.replace("{service}", "(?<service>.*)"));
            } else if (partTopic.contains("{resource}")) {
                buffer.append(partTopic.replace("{resource}", "(?<resource>.*)"));
            } else if (partTopic.contains("{value}")) {
                buffer.append(partTopic.replace("{value}", "(?<value>.*)"));
            } else if (partTopic.equals("+")) {
                buffer.append(".*");
            } else {
                buffer.append(partTopic);
            }
            Integer n = counter;
            counter = counter + 1;
        }
        return buffer.toString();
    }

    public String getGroup(String message, String groupName) throws MessageInvalidSmartTopicException {
        Matcher matcher;
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.getRegex());
        }
        if (!(matcher = this.pattern.matcher(message)).matches()) {
            throw new MessageInvalidSmartTopicException("Message value does not match the smartTopic");
        }
        try {
            return matcher.group(groupName);
        }
        catch (Exception e) {
            throw new MessageInvalidSmartTopicException(e);
        }
    }

    public String getSmartTopic() {
        return this.smartTopic;
    }
}

