/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.agent.storage.influxdb;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.sensinact.gateway.agent.storage.influxdb.InfluxDBHistoricProvider;
import org.eclipse.sensinact.gateway.agent.storage.influxdb.write.InfluxDBStorageConnection;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.historic.storage.agent.generic.StorageAgent;
import org.eclipse.sensinact.gateway.historic.storage.agent.generic.StorageConnection;
import org.eclipse.sensinact.gateway.historic.storage.reader.api.HistoricProvider;
import org.eclipse.sensinact.gateway.tools.connector.influxdb.InfluxDbConnector;
import org.eclipse.sensinact.gateway.tools.connector.influxdb.InfluxDbConnectorConfiguration;
import org.eclipse.sensinact.gateway.tools.connector.influxdb.InfluxDbDatabase;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDBStorageAgent
extends StorageAgent {
    private static final Logger LOG = LoggerFactory.getLogger(InfluxDBStorageAgent.class);
    static final String INFLUX_AGENT_URI_PROPS = "org.eclipse.sensinact.gateway.history.influx.uri";
    static final String INFLUX_AGENT_SCHEME_PROPS = "org.eclipse.sensinact.gateway.history.influx.scheme";
    static final String INFLUX_AGENT_HOST_PROPS = "org.eclipse.sensinact.gateway.history.influx.host";
    static final String INFLUX_AGENT_PORT_PROPS = "org.eclipse.sensinact.gateway.history.influx.port";
    static final String INFLUX_AGENT_PATH_PROPS = "org.eclipse.sensinact.gateway.history.influx.path";
    static final String INFLUX_AGENT_LOGIN_PROPS = "org.eclipse.sensinact.gateway.history.influx.login";
    static final String INFLUX_AGENT_PASSWORD_PROPS = "org.eclipse.sensinact.gateway.history.influx.password";
    static final String INFLUX_AGENT_DB_PROPS = "org.eclipse.sensinact.gateway.history.influx.database";
    static final String INFLUX_AGENT_MEASUREMENT_PROPS = "org.eclipse.sensinact.gateway.history.influx.measurement";
    static final String INFLUX_AGENT_DEFAULT_MEASUREMENT = "test";
    static final String DEFAULT_DATABASE = "sensinact";
    static final String STORAGE_HISTORY_PROVIDER = "sensinact.history.provider";
    private Mediator mediator;
    private InfluxDbConnector connector;
    private String measurement;
    private InfluxDbDatabase database;

    public InfluxDBStorageAgent(BundleContext bc, Dictionary<String, ?> props) {
        super(bc);
        InfluxDbConnectorConfiguration configuration;
        this.mediator = new Mediator(bc);
        String db = (String)props.get(INFLUX_AGENT_DB_PROPS);
        if (db == null) {
            db = DEFAULT_DATABASE;
        }
        String username = (String)props.get(INFLUX_AGENT_LOGIN_PROPS);
        String password = (String)props.get(INFLUX_AGENT_PASSWORD_PROPS);
        InfluxDbConnectorConfiguration.Builder builder = new InfluxDbConnectorConfiguration.Builder();
        String uri = (String)props.get(INFLUX_AGENT_URI_PROPS);
        if (uri == null) {
            String host;
            String scheme = (String)props.get(INFLUX_AGENT_SCHEME_PROPS);
            if (scheme == null) {
                scheme = "http";
            }
            if ((host = (String)props.get(INFLUX_AGENT_HOST_PROPS)) == null) {
                host = "localhost";
            }
            int port = -1;
            String portStr = (String)props.get(INFLUX_AGENT_PORT_PROPS);
            port = portStr == null ? 8086 : Integer.parseInt(portStr);
            String path = (String)props.get(INFLUX_AGENT_PATH_PROPS);
            if (path == null) {
                path = "";
            }
            configuration = builder.withScheme(scheme).withHost(host).withPort(port).withPath(path).withUsername(username).withPassword(password).build();
        } else {
            configuration = builder.withUri(uri).withUsername(username).withPassword(password).build();
        }
        try {
            this.connector = new InfluxDbConnector(configuration);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        this.measurement = (String)props.get(INFLUX_AGENT_MEASUREMENT_PROPS);
        if (this.measurement == null) {
            this.measurement = INFLUX_AGENT_DEFAULT_MEASUREMENT;
        }
        this.database = this.connector.createIfNotExists(db);
        InfluxDBHistoricProvider provider = new InfluxDBHistoricProvider(this.connector, db, this.measurement);
        this.mediator.register((Dictionary)new Hashtable<String, Object>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(InfluxDBStorageAgent.STORAGE_HISTORY_PROVIDER, InfluxDBStorageAgent.this.measurement);
            }
        }, (Object)provider, new Class[]{HistoricProvider.class});
        super.setStorageKeys((String)props.get("org.eclipse.sensinact.gateway.history.keys"));
        super.setStorageConnection((StorageConnection)new InfluxDBStorageConnection(this.database, this.measurement, props));
    }

    protected String[] getKeyProcessorProviderIdentifiers() {
        return new String[]{this.measurement};
    }
}

