/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.agent.storage.influxdb;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.sensinact.gateway.agent.storage.influxdb.InfluxDBStorageAgent;
import org.eclipse.sensinact.gateway.core.message.AgentRelay;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"service.pid=sensinact.influxdb.agent"})
public class InfluxDBStorageAgentFactory
implements ManagedServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(InfluxDBStorageAgentFactory.class);
    public static final String FACTORY_PID = "sensinact.influxdb.agent";
    public static final String AGENT_SERVICE_PROP = "sensinact.influxdb.agent.service";
    private BundleContext bundleContext;
    private Map<String, ServiceRegistration<AgentRelay>> agents;

    @Activate
    public void activate(ComponentContext ccontext) {
        this.bundleContext = ccontext.getBundleContext();
        this.agents = new HashMap<String, ServiceRegistration<AgentRelay>>();
    }

    public String getName() {
        return FACTORY_PID;
    }

    public void updated(String pid, Dictionary<String, ?> properties) throws ConfigurationException {
        this.deleted(pid);
        InfluxDBStorageAgent agent = null;
        try {
            agent = new InfluxDBStorageAgent(this.bundleContext, properties);
        }
        catch (Exception e) {
            LOG.error("No agent registered for {} ", (Object)pid);
            LOG.error(e.getMessage(), (Throwable)e);
        }
        if (agent == null) {
            return;
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        String measurement = String.valueOf(properties.get("org.eclipse.sensinact.gateway.history.influx.measurement"));
        if (measurement != null) {
            props.put(AGENT_SERVICE_PROP, measurement);
        }
        ServiceRegistration registration = this.bundleContext.registerService(AgentRelay.class, (Object)agent, props);
        this.agents.put(pid, (ServiceRegistration<AgentRelay>)registration);
        LOG.debug("Agent registered for {}", (Object)pid);
    }

    public void deleted(String pid) {
        ServiceRegistration<AgentRelay> registration = this.agents.remove(pid);
        if (registration == null || registration.getReference() == null) {
            return;
        }
        AgentRelay relay = (AgentRelay)this.bundleContext.getService(registration.getReference());
        if (relay != null) {
            ((InfluxDBStorageAgent)relay).stop();
        }
        try {
            registration.unregister();
            LOG.debug("Agent unregistered for {}", (Object)pid);
        }
        catch (IllegalStateException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }
}

