/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.topologymanager;

import org.apache.aries.rsa.topologymanager.exporter.EndpointListenerAdapter;
import org.apache.aries.rsa.topologymanager.exporter.EndpointListenerNotifier;
import org.apache.aries.rsa.topologymanager.exporter.TopologyManagerExport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.osgi.util.tracker.ServiceTracker;

final class EndpointEventListenerTracker
extends ServiceTracker {
    private TopologyManagerExport tmExport;

    EndpointEventListenerTracker(BundleContext context, TopologyManagerExport tmExport) {
        super(context, EndpointEventListenerTracker.getFilter(), null);
        this.tmExport = tmExport;
    }

    private static Filter getFilter() {
        String filterSt = String.format("(|(objectClass=%s)(objectClass=%s))", EndpointEventListener.class.getName(), EndpointListener.class.getName());
        try {
            return FrameworkUtil.createFilter((String)filterSt);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public Object addingService(ServiceReference reference) {
        Object listener = super.addingService(reference);
        EndpointEventListener actualListener = this.getListener(listener);
        this.tmExport.addEPListener(actualListener, EndpointListenerNotifier.filtersFromEEL((ServiceReference<EndpointEventListener>)reference));
        return actualListener;
    }

    private EndpointEventListener getListener(Object listener) {
        return listener instanceof EndpointEventListener ? (EndpointEventListener)listener : new EndpointListenerAdapter((EndpointListener)listener);
    }

    public void modifiedService(ServiceReference reference, Object listener) {
        EndpointEventListener actualListener = this.getListener(listener);
        this.tmExport.addEPListener(actualListener, EndpointListenerNotifier.filtersFromEEL((ServiceReference<EndpointEventListener>)reference));
        super.modifiedService(reference, (Object)actualListener);
    }

    public void removedService(ServiceReference reference, Object listener) {
        this.tmExport.removeEPListener((EndpointEventListener)listener);
        super.removedService(reference, listener);
    }
}

