/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.endpoint;

import org.eclipse.sensinact.gateway.common.execution.DefaultErrorHandler;
import org.eclipse.sensinact.gateway.common.execution.ErrorHandler;
import org.eclipse.sensinact.gateway.core.message.AbstractMidAgentCallback;
import org.eclipse.sensinact.gateway.core.message.MidCallbackException;
import org.eclipse.sensinact.gateway.core.message.SnaErrorMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaFilter;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.message.SnaResponseMessage;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessageImpl;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.Argument;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRecipient;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequest;
import org.json.JSONArray;

public class RegisterAgentRequest
extends NorthboundRequest {
    private NorthboundRecipient recipient;
    private JSONArray constraints;
    private String serviceProvider;
    private String service;
    private SnaFilter filter;
    private String policy;

    public RegisterAgentRequest(String requestIdentifier, String serviceProvider, String service, NorthboundRecipient recipient, SnaFilter filter, String policy) {
        super(requestIdentifier, null);
        this.serviceProvider = serviceProvider;
        this.service = service;
        this.recipient = recipient;
        this.filter = filter;
        this.policy = policy;
        if (this.recipient == null) {
            throw new NullPointerException("Recipient missing");
        }
    }

    @Override
    protected Argument[] getExecutionArguments() {
        AbstractMidAgentCallback callback = new AbstractMidAgentCallback(){

            public void doHandle(SnaLifecycleMessageImpl message) throws MidCallbackException {
                try {
                    RegisterAgentRequest.this.recipient.callback(this.getName(), new SnaMessage[]{message});
                }
                catch (Exception e) {
                    throw new MidCallbackException((Throwable)e);
                }
            }

            public void doHandle(SnaUpdateMessageImpl message) throws MidCallbackException {
                try {
                    RegisterAgentRequest.this.recipient.callback(this.getName(), new SnaMessage[]{message});
                }
                catch (Exception e) {
                    throw new MidCallbackException((Throwable)e);
                }
            }

            public void doHandle(SnaErrorMessageImpl message) throws MidCallbackException {
                try {
                    RegisterAgentRequest.this.recipient.callback(this.getName(), new SnaMessage[]{message});
                }
                catch (Exception e) {
                    throw new MidCallbackException((Throwable)e);
                }
            }

            public void doHandle(SnaResponseMessage<?, ?> message) throws MidCallbackException {
                try {
                    RegisterAgentRequest.this.recipient.callback(this.getName(), new SnaMessage[]{message});
                }
                catch (Exception e) {
                    throw new MidCallbackException((Throwable)e);
                }
            }
        };
        int intPolicy = 0;
        try {
            intPolicy = Integer.parseInt(this.policy);
        }
        catch (NumberFormatException e) {
            String[] policies = this.policy.split("|");
            block18: for (int index = 0; index < policies.length; ++index) {
                switch (policies[index].trim()) {
                    case "CONTINUE": {
                        intPolicy |= 1;
                        continue block18;
                    }
                    case "STOP": {
                        intPolicy |= 0x10;
                        continue block18;
                    }
                    case "ROLLBACK": {
                        intPolicy |= 0x100;
                        continue block18;
                    }
                    case "IGNORE": {
                        intPolicy |= 0x1000;
                        continue block18;
                    }
                    case "ALTERNATIVE": {
                        intPolicy |= 0x10000;
                        continue block18;
                    }
                    case "LOG": {
                        intPolicy |= 0x100000;
                    }
                }
            }
        }
        callback.setErrorHandler((ErrorHandler)new DefaultErrorHandler(intPolicy));
        Argument[] superArguments = super.getExecutionArguments();
        int length = superArguments == null ? 0 : superArguments.length;
        Argument[] arguments = new Argument[length + 2];
        if (length > 0) {
            System.arraycopy(superArguments, 0, arguments, 0, length);
        }
        arguments[length] = new Argument(AbstractMidAgentCallback.class, callback);
        arguments[length + 1] = new Argument(SnaFilter.class, this.filter);
        return arguments;
    }

    @Override
    protected String getMethod() {
        return "registerAgent";
    }

    public String getName() {
        return "/";
    }
}

