/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.ttn.osgi;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.common.annotation.Property;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModelConfiguration;
import org.eclipse.sensinact.gateway.generic.BasisActivator;
import org.eclipse.sensinact.gateway.generic.annotation.SensiNactBridgeConfiguration;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.device.MqttPacket;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.device.MqttProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.util.api.MqttAuthentication;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.util.api.MqttBroker;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.util.api.MqttTopic;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.util.listener.MqttTopicMessage;
import org.eclipse.sensinact.gateway.sthbnd.ttn.listener.TtnActivationListener;
import org.eclipse.sensinact.gateway.sthbnd.ttn.listener.TtnDownlinkListener;
import org.eclipse.sensinact.gateway.sthbnd.ttn.listener.TtnUplinkListener;
import org.osgi.annotation.bundle.Header;

@SensiNactBridgeConfiguration(startAtInitializationTime=true, resourceDefinition="ttn-resource.xml", endpointType=MqttProtocolStackEndpoint.class, resourceBuildPolicy={SensiNactResourceModelConfiguration.BuildPolicy.BUILD_COMPLETE_ON_DESCRIPTION, SensiNactResourceModelConfiguration.BuildPolicy.BUILD_NON_DESCRIBED}, serviceBuildPolicy={SensiNactResourceModelConfiguration.BuildPolicy.BUILD_COMPLETE_ON_DESCRIPTION, SensiNactResourceModelConfiguration.BuildPolicy.BUILD_NON_DESCRIBED})
@Header(name="Bundle-Activator", value="${@class}")
public class TtnActivator
extends BasisActivator<MqttPacket> {
    @Property(name="the.things.network.application.id")
    public String appId;
    @Property(name="the.things.network.application.key")
    public String appKey;
    @Property(name="the.things.network.broker.host")
    public String brokerHost;
    @Property(name="the.things.network.broker.port", defaultValue="8883")
    public Integer brokerPort;
    @Property(name="the.things.network.broker.protocol", defaultValue="SSL")
    public String brokerProtocol;

    public void configure() {
        if (this.appId == null || this.appKey == null) {
            return;
        }
        MqttAuthentication authentication = new MqttAuthentication.Builder().username(this.appId).password(this.appKey).build();
        TtnDownlinkListener ttnDownlinkListener = new TtnDownlinkListener(this.mediator);
        final MqttTopic messageTopic = new MqttTopic("+/devices/+/up", (MqttTopicMessage)new TtnUplinkListener(this.mediator, ttnDownlinkListener, (MqttProtocolStackEndpoint)this.endpoint));
        final MqttTopic activationTopic = new MqttTopic("+/devices/+/events/activations", (MqttTopicMessage)new TtnActivationListener(this.mediator, (MqttProtocolStackEndpoint)this.endpoint));
        MqttBroker broker = new MqttBroker.Builder().host(this.brokerHost).port(this.brokerPort.intValue()).protocol(MqttBroker.Protocol.valueOf((String)this.brokerProtocol)).authentication(authentication).topics((List)new ArrayList<MqttTopic>(){
            private static final long serialVersionUID = 1L;
            {
                this.add(activationTopic);
                this.add(messageTopic);
            }
        }).build();
        ttnDownlinkListener.setBroker(broker);
        ((MqttProtocolStackEndpoint)this.endpoint).addBroker(broker);
    }
}

