/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.json;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.eclipse.sensinact.gateway.util.json.JSONValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONParser {
    private static final Logger LOG = LoggerFactory.getLogger(JSONParser.class);
    private static final Pattern NUMBER_PATTERN = Pattern.compile("([1-9][0-9]*(\\.[0-9]+)?)|(0(\\.[0-9]+)?)");
    private static final Pattern BOOLEAN_PATTERN = Pattern.compile("((TRUE)|(FALSE))");
    private static final String WILDCARD = "*";
    public static final Evaluation END_OF_PARSING = new Evaluation(null, null);
    Reader reader;

    public JSONParser(String json) {
        block2: {
            this.reader = null;
            try {
                File f = new File(json);
                this.reader = f.exists() ? new FileReader(f) : new StringReader(json);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                if (this.reader != null) break block2;
                throw new NullPointerException("Null reader");
            }
        }
    }

    public JSONParser(Reader reader) {
        this.reader = null;
        if (reader == null) {
            throw new NullPointerException("Null reader");
        }
        this.reader = reader;
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            this.reader = null;
        }
    }

    public List<Evaluation> parse(List<String> paths) {
        TokenContextExtended context;
        if (paths == null || paths.isEmpty()) {
            return Collections.emptyList();
        }
        ExecutorService worker = Executors.newFixedThreadPool(5);
        List callables = paths.stream().collect(ArrayList::new, (l, s) -> l.add(new JSONParserCallable((String)s)), List::addAll);
        ArrayList<Evaluation> extractions = new ArrayList<Evaluation>();
        ArrayList<String> pathElements = new ArrayList<String>();
        Stack<Integer> indexes = new Stack<Integer>();
        JSONValidator validator = new JSONValidator(this.reader);
        while ((context = this.next(validator, pathElements, indexes)) != null) {
            try {
                callables.stream().forEach(c -> c.setTokenContext(context));
                worker.invokeAll(callables);
                int i = 0;
                while (i < callables.size()) {
                    JSONParserCallable callable = (JSONParserCallable)callables.get(i);
                    Evaluator evaluator = callable.evaluator;
                    if (evaluator.isComplete()) {
                        if (!callable.path.endsWith(WILDCARD)) {
                            callables.remove(i);
                        }
                        extractions.add(evaluator.getEvaluation());
                        continue;
                    }
                    ++i;
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        worker.shutdownNow();
        return extractions;
    }

    public void parse(List<String> paths, JSONParserCallback callback) {
        TokenContextExtended context;
        if (paths == null || paths.isEmpty()) {
            return;
        }
        ExecutorService worker = Executors.newFixedThreadPool(5);
        List callables = paths.stream().collect(ArrayList::new, (l, s) -> l.add(new JSONParserCallable((String)s)), List::addAll);
        JSONValidator validator = new JSONValidator(this.reader);
        ArrayList<String> pathElements = new ArrayList<String>();
        Stack<Integer> indexes = new Stack<Integer>();
        while ((context = this.next(validator, pathElements, indexes)) != null) {
            try {
                callables.stream().forEach(c -> c.setTokenContext(context));
                worker.invokeAll(callables);
                int i = 0;
                while (i < callables.size()) {
                    JSONParserCallable callable = (JSONParserCallable)callables.get(i);
                    Evaluator evaluator = callable.evaluator;
                    if (evaluator.isComplete()) {
                        callback.handle(evaluator.getEvaluation());
                        continue;
                    }
                    ++i;
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        callback.handle(END_OF_PARSING);
        worker.shutdownNow();
    }

    private TokenContextExtended next(JSONValidator validator, List<String> pathElements, Stack<Integer> indexes) {
        int index = -1;
        String key = null;
        JSONValidator.JSONToken token = null;
        try {
            token = validator.nextToken();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        if (token == null) {
            return null;
        }
        switch (token) {
            case JSON_ARRAY_OPENING: {
                String string = key = token.getContext() == null ? null : token.getContext().key;
                if (key != null) {
                    pathElements.remove(pathElements.size() - 1);
                    pathElements.add(key);
                } else if (indexes.size() > 0) {
                    index = indexes.pop();
                    indexes.push(++index);
                    pathElements.remove(pathElements.size() - 1);
                    pathElements.add(String.format("[%s]", index));
                }
                index = -1;
                indexes.push(index);
                pathElements.add("[]");
                break;
            }
            case JSON_ARRAY_ITEM: {
                index = indexes.pop();
                indexes.push(++index);
                pathElements.remove(pathElements.size() - 1);
                pathElements.add(String.format("[%s]", index));
                break;
            }
            case JSON_ARRAY_CLOSING: {
                indexes.pop();
                pathElements.remove(pathElements.size() - 1);
                break;
            }
            case JSON_OBJECT_OPENING: {
                String string = key = token.getContext() == null ? null : token.getContext().key;
                if (key != null) {
                    pathElements.remove(pathElements.size() - 1);
                    pathElements.add(key);
                } else if (indexes.size() > 0) {
                    index = indexes.pop();
                    indexes.push(++index);
                    pathElements.remove(pathElements.size() - 1);
                    pathElements.add(String.format("[%s]", index));
                }
                pathElements.add("{}");
                break;
            }
            case JSON_OBJECT_CLOSING: {
                pathElements.remove(pathElements.size() - 1);
                break;
            }
            case JSON_OBJECT_ITEM: {
                pathElements.remove(pathElements.size() - 1);
                String string = key = token.getContext() == null ? null : token.getContext().key;
                if (key != null) {
                    pathElements.add(key);
                    break;
                }
                pathElements.add("#UNKNOWN#");
                break;
            }
        }
        TokenContextExtended context = new TokenContextExtended();
        context.token = token;
        context.value = token.getContext() == null ? null : String.valueOf(token.getContext().value);
        context.key = token.getContext() == null ? null : token.getContext().key;
        context.path = pathElements.stream().collect(StringBuilder::new, (sb, s) -> {
            sb.append("/");
            sb.append((String)s);
        }, (sb1, sb2) -> sb1.append(sb2.toString())).toString();
        return context;
    }

    public static void main(String[] args) {
        String s = "{\"key0\":null,\"key1\":[\"machin\",\"chose\",2],\"key2\":{\"key20\":\"truc\",\"key21\":45},\"key3\":{\"key30\":[{\"key300\":\"bidule\",\"key301\":[8,2,1]},[18,\"intermediate\"],\"standalone\",{\"key300\":\"chose\",\"key301\":[10,20,11]}]}}";
        List<Evaluation> extractions = new JSONParser(s).parse(Arrays.asList(WILDCARD, "/key3/key30/[3]/key301", "/key3/key30/[0]", "/key3", "/key3/key30/[2]", "/key2/key20", "/key2/key25", "/key3/key30/[3]/key301/*"));
        extractions.stream().forEach(e -> System.out.println(e.path + " : " + e.result));
        JSONParserCallback callback = new JSONParserCallback(){

            @Override
            public void handle(Evaluation e) {
                System.out.println("--------------------------------------------------------");
                if (e == END_OF_PARSING) {
                    System.out.println("end of parsing");
                } else {
                    System.out.println(e.path + " : " + e.result);
                }
                System.out.println("--------------------------------------------------------");
            }
        };
        new JSONParser(s).parse(Arrays.asList("key3/key30/[3]/key301/*", "/key3/key30/*", "/key3/key30/[0]/*", "/key3/*"), callback);
        s = "[null,[\"machin\",\"chose\",2],{\"key20\":\"truc\",\"key21\":45},{\"key30\":[{\"key300\":\"bidule\",\"key301\":[8,2,1]},[18,\"intermediate\"],\"standalone\",{\"key300\":\"chose\",\"key301\":[10,20,11]}]}]";
        callback = new JSONParserCallback(){

            @Override
            public void handle(Evaluation e) {
                System.out.println("--------------------------------------------------------");
                if (e == END_OF_PARSING) {
                    System.out.println("end of parsing");
                } else {
                    System.out.println(e.path + " : " + e.result);
                }
                System.out.println("--------------------------------------------------------");
            }
        };
        new JSONParser(s).parse(Arrays.asList(WILDCARD), callback);
    }

    class TokenContextExtended {
        public String key;
        public String value;
        public String path;
        public JSONValidator.JSONToken token;

        TokenContextExtended() {
        }
    }

    class JSONParserCallable
    implements Callable<Void> {
        final String path;
        final Evaluator evaluator;
        TokenContextExtended context;

        public JSONParserCallable(String path) {
            this.path = path;
            this.evaluator = new Evaluator(path);
        }

        @Override
        public Void call() throws Exception {
            if (this.context == null) {
                return null;
            }
            this.evaluator.process(this.context);
            return null;
        }

        public void setTokenContext(TokenContextExtended context) {
            this.context = context;
        }
    }

    class Evaluator {
        String path = null;
        String[] pathElements = null;
        StringBuilder builder = null;
        int lastIndex = -1;
        Stack<Nested> nesteds = new Stack();
        Stack<Integer> indexes = new Stack();
        boolean complete = false;

        Evaluator(String path) {
            this.path = path;
            String formatedPath = path;
            if (path.startsWith("/")) {
                formatedPath = formatedPath.substring(1);
            }
            if (path.endsWith("/")) {
                formatedPath = formatedPath.substring(0, formatedPath.length() - 1);
            }
            this.pathElements = formatedPath.split("/");
            this.lastIndex = this.pathElements.length - 1;
            this.builder = new StringBuilder();
        }

        boolean isComplete() {
            return this.complete;
        }

        Evaluation getEvaluation() {
            Evaluation extraction = new Evaluation(this.path, this.builder.toString());
            if (JSONParser.WILDCARD.equals(this.pathElements[this.lastIndex])) {
                this.complete = false;
                this.builder = new StringBuilder();
            }
            return extraction;
        }

        void process(TokenContextExtended context) {
            int i;
            String[] _pathElements;
            if (this.complete) {
                return;
            }
            String value = null;
            value = context.value != null && !NUMBER_PATTERN.matcher(context.value).matches() && !BOOLEAN_PATTERN.matcher(context.value.toUpperCase()).matches() ? String.format("\"%s\"", context.value.replaceAll("\"", "\\\"")) : context.value;
            String formatedPath = context.path;
            if (context.path.startsWith("/")) {
                formatedPath = formatedPath.substring(1);
            }
            if (context.path.endsWith("/")) {
                formatedPath = formatedPath.substring(0, formatedPath.length() - 1);
            }
            int length = (_pathElements = formatedPath.split("/")).length < this.pathElements.length ? _pathElements.length : this.pathElements.length;
            for (i = 0; i < length; ++i) {
                String pathElement = this.pathElements[i];
                String _pathElement = _pathElements[i];
                if (!JSONParser.WILDCARD.equals(pathElement) && !_pathElement.equals(pathElement)) break;
            }
            if (i == length && length == this.pathElements.length) {
                switch (context.token) {
                    case JSON_ARRAY_OPENING: {
                        if (!this.indexes.isEmpty() && this.nesteds.peek().equals((Object)Nested.OBJECT)) {
                            int objectIndex = this.indexes.pop();
                            this.indexes.push(new Integer(++objectIndex));
                            if (objectIndex > 0) {
                                this.builder.append(",");
                            }
                            this.builder.append("\"");
                            this.builder.append(context.key);
                            this.builder.append("\":");
                        } else if (!this.indexes.isEmpty() && this.nesteds.peek().equals((Object)Nested.ARRAY)) {
                            int arrayIndex = this.indexes.pop();
                            this.indexes.push(new Integer(++arrayIndex));
                            if (arrayIndex > 0) {
                                this.builder.append(",");
                            }
                        }
                        this.builder.append("[");
                        this.nesteds.push(Nested.ARRAY);
                        this.indexes.push(new Integer(-1));
                        break;
                    }
                    case JSON_ARRAY_ITEM: {
                        if (!this.indexes.isEmpty() && this.nesteds.peek().equals((Object)Nested.ARRAY)) {
                            int arrayIndex = this.indexes.pop();
                            this.indexes.push(new Integer(++arrayIndex));
                            if (arrayIndex > 0 && this.builder.length() > 0) {
                                this.builder.append(",");
                            }
                        }
                        this.builder.append(value);
                        break;
                    }
                    case JSON_ARRAY_CLOSING: {
                        this.builder.append("]");
                        this.indexes.pop();
                        this.nesteds.pop();
                        break;
                    }
                    case JSON_OBJECT_OPENING: {
                        if (!this.indexes.isEmpty() && this.nesteds.peek().equals((Object)Nested.OBJECT)) {
                            int objectIndex = this.indexes.pop();
                            this.indexes.push(new Integer(++objectIndex));
                            if (objectIndex > 0) {
                                this.builder.append(",");
                            }
                            this.builder.append("\"");
                            this.builder.append(context.key);
                            this.builder.append("\":");
                        } else if (!this.indexes.isEmpty() && this.nesteds.peek().equals((Object)Nested.ARRAY)) {
                            int arrayIndex = this.indexes.pop();
                            this.indexes.push(new Integer(++arrayIndex));
                            if (arrayIndex > 0) {
                                this.builder.append(",");
                            }
                        }
                        this.builder.append("{");
                        this.nesteds.push(Nested.OBJECT);
                        this.indexes.push(new Integer(-1));
                        break;
                    }
                    case JSON_OBJECT_ITEM: {
                        if (!this.indexes.isEmpty() && this.nesteds.peek().equals((Object)Nested.OBJECT)) {
                            int objectIndex = this.indexes.pop();
                            this.indexes.push(new Integer(++objectIndex));
                            if (objectIndex > 0 && this.builder.length() > 0) {
                                this.builder.append(",");
                            }
                            this.builder.append("\"");
                            this.builder.append(context.key);
                            this.builder.append("\"");
                            this.builder.append(":");
                        }
                        this.builder.append(value);
                        break;
                    }
                    case JSON_OBJECT_CLOSING: {
                        this.builder.append("}");
                        this.indexes.pop();
                        this.nesteds.pop();
                        break;
                    }
                }
                if (this.pathElements.length == _pathElements.length) {
                    if (!(JSONParser.WILDCARD.equals(this.pathElements[this.lastIndex]) && (context.token.equals((Object)JSONValidator.JSONToken.JSON_ARRAY_OPENING) || context.token.equals((Object)JSONValidator.JSONToken.JSON_OBJECT_OPENING) || context.token.equals((Object)JSONValidator.JSONToken.JSON_OBJECT_CLOSING) && this.indexes.size() <= 0 || context.token.equals((Object)JSONValidator.JSONToken.JSON_ARRAY_CLOSING) && this.indexes.size() <= 0))) {
                        this.complete = true;
                    } else {
                        this.builder = new StringBuilder();
                    }
                }
            }
        }
    }

    public static class Evaluation {
        public final String path;
        public final String result;

        public Evaluation(String path, String result) {
            this.path = path;
            this.result = result != null && result.startsWith(",") ? result.substring(1) : result;
        }
    }

    public static abstract class JSONParserCallback {
        public abstract void handle(Evaluation var1);
    }

    static enum Nested {
        OBJECT,
        ARRAY;

    }
}

