/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.agent.mqtt.onem2m.internal;

import java.io.IOException;
import java.util.UUID;
import org.eclipse.sensinact.gateway.agent.mqtt.generic.internal.AbstractMqttHandler;
import org.eclipse.sensinact.gateway.core.message.SnaErrorMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessage;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaResponseMessage;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessage;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessageImpl;
import org.json.JSONArray;
import org.json.JSONObject;

public class SnaEventOneM2MMqttHandler
extends AbstractMqttHandler {
    private final String cseBase;
    private static final String REQUEST_TOPIC = "/oneM2M/req/";

    public SnaEventOneM2MMqttHandler(String cseBase) throws IOException {
        this.cseBase = cseBase;
    }

    public void doHandle(SnaUpdateMessageImpl event) {
        JSONObject eventJson = new JSONObject(event.getJSON()).getJSONObject("notification");
        String aeName = event.getPath().split("/")[1];
        String containerServiceName = event.getPath().split("/")[2];
        String containerResourceName = event.getPath().split("/")[2];
        JSONObject request = new JSONObject().put("fr", (Object)aeName).put("to", (Object)("/" + this.cseBase + "/" + aeName + "/" + containerServiceName + "/" + containerResourceName)).put("rqi", (Object)UUID.randomUUID().toString());
        JSONObject content = new JSONObject();
        switch ((SnaUpdateMessage.Update)event.getType()) {
            case ATTRIBUTE_VALUE_UPDATED: {
                request.put("op", 1);
                request.put("ty", 4);
                content.put("con", eventJson.get("value"));
                request.put("pc", (Object)new JSONObject().put("m2m:cin", (Object)content));
                break;
            }
            default: {
                return;
            }
        }
        this.agent.publish(REQUEST_TOPIC + aeName + "/" + this.cseBase + "/json", new JSONObject().put("m2m:rqp", (Object)request).toString());
    }

    public void doHandle(SnaLifecycleMessageImpl event) {
        String aeName = event.getPath().split("/")[1];
        JSONObject request = new JSONObject().put("fr", (Object)aeName).put("rqi", (Object)UUID.randomUUID().toString());
        JSONObject content = new JSONObject();
        switch ((SnaLifecycleMessage.Lifecycle)event.getType()) {
            case PROVIDER_APPEARING: {
                request.put("op", 1);
                request.put("ty", 2);
                request.put("to", (Object)("/" + this.cseBase));
                content.put("rn", (Object)aeName);
                content.put("api", (Object)"0.2.481.2.0001.001.000111");
                content.put("lbl", (Object)new JSONArray().put((Object)"key1").put((Object)"key2"));
                content.put("rr", true);
                request.put("pc", (Object)new JSONObject().put("m2m:ae", (Object)content));
                break;
            }
            case PROVIDER_DISAPPEARING: {
                request.put("op", 4);
                request.put("ty", 2);
                request.put("to", (Object)("/" + this.cseBase));
                content.put("rn", (Object)aeName);
                request.put("pc", (Object)new JSONObject().put("m2m:ae", (Object)content));
                break;
            }
            case SERVICE_APPEARING: {
                request.put("op", 1);
                request.put("ty", 3);
                request.put("to", (Object)("/" + this.cseBase + "/" + aeName));
                content.put("rn", (Object)event.getPath().split("/")[2]);
                content.put("lbl", (Object)new JSONArray().put((Object)aeName));
                request.put("pc", (Object)new JSONObject().put("m2m:cnt", (Object)content));
                break;
            }
            case SERVICE_DISAPPEARING: {
                request.put("op", 4);
                request.put("ty", 3);
                request.put("to", (Object)("/" + this.cseBase + "/" + aeName));
                content.put("rn", (Object)event.getPath().split("/")[2]);
                request.put("pc", (Object)new JSONObject().put("m2m:cnt", (Object)content));
                break;
            }
            case RESOURCE_APPEARING: {
                request.put("op", 1);
                request.put("ty", 3);
                request.put("to", (Object)("/" + this.cseBase + "/" + aeName + "/" + event.getPath().split("/")[2]));
                content.put("rn", (Object)event.getPath().split("/")[3]);
                content.put("lbl", (Object)new JSONArray().put((Object)aeName));
                request.put("pc", (Object)new JSONObject().put("m2m:cnt", (Object)content));
                break;
            }
            case RESOURCE_DISAPPEARING: {
                request.put("op", 4);
                request.put("ty", 3);
                request.put("to", (Object)("/" + this.cseBase + "/" + aeName + "/" + event.getPath().split("/")[2]));
                content.put("rn", (Object)event.getPath().split("/")[3]);
                request.put("pc", (Object)new JSONObject().put("m2m:cnt", (Object)content));
                break;
            }
            default: {
                return;
            }
        }
        this.agent.publish(REQUEST_TOPIC + aeName + "/" + this.cseBase + "/json", new JSONObject().put("m2m:rqp", (Object)request).toString());
    }

    public void stop() {
    }

    public void doHandle(SnaErrorMessageImpl event) {
    }

    public void doHandle(SnaResponseMessage<?, ?> event) {
    }
}

