/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.packet;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketException;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketTypeException;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.generic.packet.PacketReader;
import org.eclipse.sensinact.gateway.generic.packet.PojoPacketWrapper;
import org.eclipse.sensinact.gateway.generic.packet.SimplePacketReader;
import org.eclipse.sensinact.gateway.generic.packet.StructuredPacket;
import org.eclipse.sensinact.gateway.generic.packet.SubPacket;
import org.eclipse.sensinact.gateway.generic.packet.annotation.AttributeID;
import org.eclipse.sensinact.gateway.generic.packet.annotation.CommandID;
import org.eclipse.sensinact.gateway.generic.packet.annotation.Data;
import org.eclipse.sensinact.gateway.generic.packet.annotation.GoodbyeMessage;
import org.eclipse.sensinact.gateway.generic.packet.annotation.HelloMessage;
import org.eclipse.sensinact.gateway.generic.packet.annotation.Iteration;
import org.eclipse.sensinact.gateway.generic.packet.annotation.MetadataID;
import org.eclipse.sensinact.gateway.generic.packet.annotation.ProfileID;
import org.eclipse.sensinact.gateway.generic.packet.annotation.ResourceID;
import org.eclipse.sensinact.gateway.generic.packet.annotation.ServiceID;
import org.eclipse.sensinact.gateway.generic.packet.annotation.ServiceProviderID;
import org.eclipse.sensinact.gateway.generic.packet.annotation.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructuredPacketReader<P extends Packet>
extends SimplePacketReader<P> {
    private static final Logger LOG = LoggerFactory.getLogger(PacketReader.class);
    private static final List<String> ANNOTATIONS = Arrays.asList(AttributeID.class.getCanonicalName(), CommandID.class.getCanonicalName(), Data.class.getCanonicalName(), Iteration.class.getCanonicalName(), MetadataID.class.getCanonicalName(), ProfileID.class.getCanonicalName(), ResourceID.class.getCanonicalName(), ServiceID.class.getCanonicalName(), ServiceProviderID.class.getCanonicalName(), Timestamp.class.getCanonicalName(), HelloMessage.class.getCanonicalName(), GoodbyeMessage.class.getCanonicalName());
    private PojoPacketWrapper<P> wrapper = null;
    private Iterator<SubPacket> iterator = null;

    public StructuredPacketReader() {
    }

    public StructuredPacketReader(Class<P> packetType) throws InvalidPacketTypeException {
        this();
        boolean isAnnotated = false;
        Field[] fields = packetType.getDeclaredFields();
        int fieldsLength = fields == null ? 0 : fields.length;
        Method[] methods = packetType.getDeclaredMethods();
        int methodsLength = methods == null ? 0 : methods.length;
        AnnotatedElement[] elements = new AnnotatedElement[fieldsLength + methodsLength];
        if (fieldsLength > 0) {
            System.arraycopy(fields, 0, elements, 0, fieldsLength);
        }
        if (methodsLength > 0) {
            System.arraycopy(methods, 0, elements, fieldsLength, methodsLength);
        }
        int length = elements == null ? 0 : elements.length;
        PojoPacketWrapper wrapper = new PojoPacketWrapper();
        for (int index = 0; index < length; ++index) {
            int annotationLength;
            Annotation[] annotations = null;
            try {
                annotations = elements[index].getAnnotations();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int n = annotationLength = annotations == null ? 0 : annotations.length;
            for (int annotationIndex = 0; annotationIndex < annotationLength; ++annotationIndex) {
                Class<? extends Annotation> annotationType = annotations[annotationIndex].annotationType();
                int ind = ANNOTATIONS.indexOf(annotationType.getCanonicalName());
                if (ind < 0) continue;
                String annotationName = annotationType.getSimpleName();
                annotationName = annotationName.substring(0, 1).toLowerCase() + annotationName.substring(1) + "Annotated";
                try {
                    Field annotationField = PojoPacketWrapper.class.getDeclaredField(annotationName);
                    annotationField.setAccessible(true);
                    annotationField.set(wrapper, elements[index]);
                    isAnnotated = true;
                    continue;
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    throw new InvalidPacketTypeException(e);
                }
            }
        }
        if (!isAnnotated) {
            throw new InvalidPacketTypeException();
        }
        this.wrapper = wrapper;
    }

    @Override
    public void load(P packet) throws InvalidPacketException {
        super.reset();
        PojoPacketWrapper<P> structuredPacket = null;
        if (StructuredPacket.class.isAssignableFrom(packet.getClass())) {
            structuredPacket = (PojoPacketWrapper<P>)packet;
        } else if (this.wrapper != null) {
            this.wrapper.wrap(packet);
            structuredPacket = this.wrapper;
        }
        if (structuredPacket == null) {
            return;
        }
        this.iterator = structuredPacket.iterator();
    }

    @Override
    public void parse() throws InvalidPacketException {
        if (this.iterator == null) {
            return;
        }
        if (!this.iterator.hasNext()) {
            this.iterator = null;
            super.configureEOF();
            return;
        }
        super.reset();
        SubPacket subPacket = this.iterator.next();
        super.isGoodbyeMessage(subPacket.isGoodbyeMessage());
        super.isHelloMessage(subPacket.isHelloMessage());
        super.setCommand(subPacket.getCommand());
        super.setProfileId(subPacket.getProfileId());
        super.setServiceProviderId(subPacket.getServiceProviderId());
        super.setServiceId(subPacket.getServiceId());
        super.setResourceId(subPacket.getResourceId());
        super.setAttributeId(subPacket.getAttributeId());
        super.setMetadataId(subPacket.getMetadataId());
        super.setTimestamp(subPacket.getTimestamp());
        super.setData(subPacket.getData());
        super.configure();
    }
}

