/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.ExtResourceImpl;
import org.eclipse.sensinact.gateway.generic.parser.XmlElement;
import org.eclipse.sensinact.gateway.generic.parser.XmlModelParsingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

@XmlElement(tag="className", field="resourceClassType")
final class ResourceClassDefinition
extends XmlModelParsingContext {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceClassDefinition.class);
    private Class<? extends ExtResourceImpl> resourceClassType;

    public ResourceClassDefinition(Mediator mediator, Attributes atts) {
        super(mediator, atts);
    }

    void setResourceClassType(String className) {
        if (className == null || className.length() == 0) {
            return;
        }
        try {
            this.resourceClassType = this.mediator.getClassLoader().loadClass(className);
            if (this.resourceClassType.isInterface()) {
                this.resourceClassType = null;
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public Class<? extends ExtResourceImpl> getResourceClassType() {
        return this.resourceClassType;
    }
}

