/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.http.callback;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.sensinact.gateway.nthbnd.http.callback.ResponseWrapper;

public abstract class AbstractResponseWrapper
implements ResponseWrapper {
    protected static final Logger LOG = Logger.getLogger(ResponseWrapper.class.getName());
    protected int statusCode;
    protected byte[] content;
    protected Map<String, List<String>> attributes;

    protected static String getParameter(Map<String, List<String>> map, String name) throws UnsupportedEncodingException {
        String parameter = null;
        if (name == null || name.length() == 0) {
            return parameter;
        }
        List<String> values = map.get(name = URLDecoder.decode(name, "UTF-8"));
        if (values == null) {
            return parameter;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String value : values) {
            if (!first) {
                builder.append(' ');
            }
            builder.append(value);
            first = false;
        }
        parameter = builder.toString();
        return parameter;
    }

    @Override
    public void setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    @Override
    public void setContent(String content) {
        if (content == null) {
            this.content = new byte[0];
            return;
        }
        this.content = content.getBytes();
    }

    @Override
    public void setContent(byte[] content) {
        if (content == null || content.length == 0) {
            this.content = new byte[0];
            return;
        }
        this.content = new byte[content.length];
        System.arraycopy(content, 0, this.content, 0, content.length);
    }

    @Override
    public void setError(Throwable t) {
        this.setError(500, t == null ? null : (t.getMessage() == null ? t.getClass().getName() : t.getMessage()));
    }

    @Override
    public void setError(int status, String message) {
        this.statusCode = status;
        this.content = (message == null ? "An error occurred" : message).getBytes();
    }

    @Override
    public void setResponseStatus(int status) {
        this.statusCode = status;
    }
}

