/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.core.ModelElementProxyBuildException;
import org.eclipse.sensinact.gateway.core.ModelInstance;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModel;
import org.eclipse.sensinact.gateway.core.Service;
import org.eclipse.sensinact.gateway.core.ServiceProvider;
import org.eclipse.sensinact.gateway.core.SessionKey;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.remote.SensinactCoreBaseIFaceManager;
import org.eclipse.sensinact.gateway.core.security.AccessLevelOption;
import org.eclipse.sensinact.gateway.core.security.AccessNode;
import org.eclipse.sensinact.gateway.core.security.AccessTree;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegistryEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryEndpoint.class);
    private Mediator mediator;
    private final String defaultLocation;

    public RegistryEndpoint(Mediator mediator) {
        this.mediator = mediator;
        this.defaultLocation = ModelInstance.defaultLocation(mediator);
    }

    protected Collection<ServiceReference<SensiNactResourceModel>> getReferences(SessionKey sessionKey, String filter) {
        return this.getReferences(sessionKey.getAccessTree(), filter);
    }

    protected Collection<ServiceReference<SensiNactResourceModel>> getReferences(AccessTree<? extends AccessNode> tree, String filter) {
        AccessMethod.Type describe = AccessMethod.Type.valueOf(AccessMethod.DESCRIBE);
        ArrayList<ServiceReference<SensiNactResourceModel>> result = new ArrayList<ServiceReference<SensiNactResourceModel>>();
        Collection references = null;
        try {
            references = this.mediator.getContext().getServiceReferences(SensiNactResourceModel.class, filter);
            for (ServiceReference reference : references) {
                AccessNode node;
                String name;
                Integer level = (Integer)reference.getProperty((name = (String)reference.getProperty("name")).concat(".DESCRIBE"));
                if (level == null) {
                    level = AccessLevelOption.OWNER.getAccessLevel().getLevel();
                }
                if ((node = tree.getRoot().get(UriUtils.getUri((String[])new String[]{name}))) == null) {
                    node = tree.getRoot();
                }
                if (node.getAccessLevelOption(describe).getAccessLevel().getLevel() < level) continue;
                result.add((ServiceReference<SensiNactResourceModel>)reference);
            }
        }
        catch (InvalidSyntaxException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String getAll(SessionKey sessionKey, boolean resolveNamespace, String filter) {
        boolean addIcon;
        boolean addBridge;
        StringBuilder builder = new StringBuilder();
        int index = -1;
        Collection<ServiceReference<SensiNactResourceModel>> references = this.getReferences(sessionKey, filter);
        Iterator<ServiceReference<SensiNactResourceModel>> iterator = references.iterator();
        AccessTree<? extends AccessNode> tree = sessionKey.getAccessTree();
        AccessNode root = sessionKey.getAccessTree().getRoot();
        AccessMethod.Type describe = AccessMethod.Type.valueOf(AccessMethod.DESCRIBE);
        AccessMethod.Type get = AccessMethod.Type.valueOf(AccessMethod.GET);
        boolean bl = filter == null ? false : (addBridge = filter.indexOf("admin.bridge.value") > -1);
        boolean bl2 = filter == null ? false : (addIcon = filter.indexOf("admin.icon.value") > -1);
        boolean addFriendlyName = filter == null ? false : filter.indexOf("admin.friendlyName.value") > -1;
        String namespace = this.namespace();
        String prefix = "";
        if (!"#LOCAL#".equals(namespace) && sessionKey.localID() != 0) {
            prefix = namespace.concat(":");
        }
        while (iterator.hasNext()) {
            int slength;
            String resourceUri;
            AccessNode node;
            ++index;
            ServiceReference<SensiNactResourceModel> reference = iterator.next();
            String name = (String)reference.getProperty("name");
            String provider = prefix + name;
            String location = null;
            Object obj = reference.getProperty(ModelInstance.LOCATION_PROPERTY.concat(".value"));
            location = obj == null || "null".equals(String.valueOf(obj)) ? this.defaultLocation : String.valueOf(obj).replace('\"', '\'');
            Integer locationGetLevel = (Integer)reference.getProperty(ModelInstance.LOCATION_PROPERTY.concat(".GET"));
            if (locationGetLevel == null) {
                locationGetLevel = AccessLevelOption.OWNER.getAccessLevel().getLevel();
            }
            if ((node = root.get(resourceUri = UriUtils.getUri((String[])new String[]{name, "admin", "location"}))) == null) {
                node = tree.getRoot();
            }
            int locationAccessLevel = node.getAccessLevelOption(get).getAccessLevel().getLevel();
            obj = reference.getProperty(ModelInstance.FRIENDLY_NAME_PROPERTY.concat(".value"));
            String friendlyName = obj == null || "null".equals(String.valueOf(obj)) ? null : String.valueOf(obj).replace('\"', '\'');
            Integer friendlyNameGetLevel = (Integer)reference.getProperty(ModelInstance.FRIENDLY_NAME_PROPERTY.concat(".GET"));
            if (friendlyNameGetLevel == null) {
                friendlyNameGetLevel = AccessLevelOption.OWNER.getAccessLevel().getLevel();
            }
            if ((node = root.get(resourceUri = UriUtils.getUri((String[])new String[]{name, "admin", "friendlyName"}))) == null) {
                node = tree.getRoot();
            }
            int friendlyNameAccessLevel = node.getAccessLevelOption(get).getAccessLevel().getLevel();
            obj = reference.getProperty(ModelInstance.BRIDGE_PROPERTY.concat(".value"));
            String bridge = obj == null || "null".equals(String.valueOf(obj)) ? null : String.valueOf(obj).replace('\"', '\'');
            Integer bridgeGetLevel = (Integer)reference.getProperty(ModelInstance.BRIDGE_PROPERTY.concat(".GET"));
            if (bridgeGetLevel == null) {
                bridgeGetLevel = AccessLevelOption.OWNER.getAccessLevel().getLevel();
            }
            if ((node = root.get(resourceUri = UriUtils.getUri((String[])new String[]{name, "admin", "bridge"}))) == null) {
                node = tree.getRoot();
            }
            int bridgeAccessLevel = node.getAccessLevelOption(get).getAccessLevel().getLevel();
            obj = reference.getProperty(ModelInstance.ICON_PROPERTY.concat(".value"));
            String icon = obj == null || "null".equals(String.valueOf(obj)) ? null : String.valueOf(obj).replace('\"', '\'');
            Integer iconGetLevel = (Integer)reference.getProperty(ModelInstance.ICON_PROPERTY.concat(".GET"));
            if (iconGetLevel == null) {
                iconGetLevel = AccessLevelOption.OWNER.getAccessLevel().getLevel();
            }
            if ((node = root.get(resourceUri = UriUtils.getUri((String[])new String[]{name, "admin", "icon"}))) == null) {
                node = tree.getRoot();
            }
            int iconAccessLevel = node.getAccessLevelOption(get).getAccessLevel().getLevel();
            List serviceList = (List)reference.getProperty("services");
            builder.append(index > 0 ? Character.valueOf(',') : "");
            builder.append('{');
            builder.append("\"name\":");
            builder.append('\"');
            builder.append(provider);
            builder.append('\"');
            if (!"#LOCAL#".equals(namespace)) {
                builder.append(",\"namespace\":");
                builder.append('\"');
                builder.append(namespace);
                builder.append('\"');
            }
            if (locationAccessLevel >= locationGetLevel) {
                builder.append(",\"location\":");
                if (location != null) {
                    builder.append('\"');
                }
                builder.append(location);
                if (location != null) {
                    builder.append('\"');
                }
            }
            if (addBridge && bridgeAccessLevel >= bridgeGetLevel) {
                builder.append(",\"bridge\":");
                if (bridge != null) {
                    builder.append('\"');
                }
                builder.append(bridge);
                if (bridge != null) {
                    builder.append('\"');
                }
            }
            if (addIcon && iconAccessLevel >= iconGetLevel) {
                builder.append(",\"icon\":");
                if (icon != null) {
                    builder.append('\"');
                }
                builder.append(icon);
                if (icon != null) {
                    builder.append('\"');
                }
            }
            if (addFriendlyName && friendlyNameAccessLevel >= friendlyNameGetLevel) {
                builder.append(",\"friendlyName\":");
                if (friendlyName != null) {
                    builder.append('\"');
                }
                builder.append(friendlyName);
                if (friendlyName != null) {
                    builder.append('\"');
                }
            }
            builder.append(",\"services\":");
            builder.append('[');
            int pos = 0;
            int n = slength = serviceList == null ? 0 : serviceList.size();
            for (int sindex = 0; sindex < slength; ++sindex) {
                int rlength;
                int describeAccessLevel;
                String service = (String)serviceList.get(sindex);
                String serviceUri = UriUtils.getUri((String[])new String[]{name, service});
                Integer serviceLevel = (Integer)reference.getProperty(service.concat(".DESCRIBE"));
                if (serviceLevel == null) {
                    serviceLevel = AccessLevelOption.OWNER.getAccessLevel().getLevel();
                }
                if ((node = root.get(serviceUri)) == null) {
                    node = tree.getRoot();
                }
                if ((describeAccessLevel = node.getAccessLevelOption(describe).getAccessLevel().getLevel()) < serviceLevel) continue;
                List resourceList = (List)reference.getProperty(service.concat(".resources"));
                builder.append(pos > 0 ? Character.valueOf(',') : "");
                builder.append('{');
                builder.append("\"name\":");
                builder.append('\"');
                builder.append(service);
                builder.append('\"');
                builder.append(",\"resources\":");
                builder.append('[');
                int rpos = 0;
                int n2 = rlength = resourceList == null ? 0 : resourceList.size();
                for (int rindex = 0; rindex < rlength; ++rindex) {
                    String resource = (String)resourceList.get(rindex);
                    String resolvedResource = service + "." + resource;
                    resourceUri = UriUtils.getUri((String[])new String[]{name, service, resource});
                    Integer resourceLevel = (Integer)reference.getProperty(resolvedResource.concat(".DESCRIBE"));
                    if (resourceLevel == null) {
                        resourceLevel = AccessLevelOption.OWNER.getAccessLevel().getLevel();
                    }
                    if ((node = root.get(resourceUri)) == null) {
                        node = tree.getRoot();
                    }
                    if ((describeAccessLevel = node.getAccessLevelOption(describe).getAccessLevel().getLevel()) < resourceLevel) continue;
                    String type = (String)reference.getProperty(resolvedResource.concat(".type"));
                    String rws = null;
                    block6 : switch (type) {
                        case "PROPERTY": 
                        case "STATE_VARIABLE": 
                        case "SENSOR": {
                            StringBuilder sbuilder = new StringBuilder();
                            sbuilder.append(resolvedResource);
                            sbuilder.append(".");
                            sbuilder.append("value");
                            sbuilder.append(".");
                            sbuilder.append("modifiable");
                            String st = (String)reference.getProperty(sbuilder.toString());
                            if (st == null) break;
                            switch (st) {
                                case "MODIFIABLE": {
                                    rws = "RW";
                                    break block6;
                                }
                                case "FIXED": 
                                case "UPDATABLE": {
                                    rws = "RO";
                                    break block6;
                                }
                            }
                            break;
                        }
                    }
                    builder.append(rpos > 0 ? Character.valueOf(',') : "");
                    builder.append('{');
                    builder.append("\"name\":");
                    builder.append('\"');
                    builder.append(resource);
                    builder.append('\"');
                    builder.append(",\"type\":");
                    builder.append('\"');
                    builder.append(type);
                    builder.append('\"');
                    if (rws != null) {
                        builder.append(",\"rws\":");
                        builder.append('\"');
                        builder.append(rws);
                        builder.append('\"');
                    }
                    builder.append('}');
                    ++rpos;
                }
                builder.append(']');
                builder.append('}');
                ++pos;
            }
            builder.append(']');
            builder.append('}');
        }
        String content = builder.toString();
        return content;
    }

    public String getProviders(final SessionKey sessionKey, boolean resolveNamespace, final boolean resolveServices, String filter) {
        boolean addFriendlyName;
        boolean addIcon;
        boolean addBridge;
        String providersFilter;
        String activeFilter = "(lifecycle.status=ACTIVE)";
        if (filter == null) {
            providersFilter = activeFilter;
        } else {
            StringBuilder filterBuilder = new StringBuilder().append("(&");
            if (!filter.startsWith("(")) {
                filterBuilder.append("(");
            }
            filterBuilder.append(filter);
            if (!filter.endsWith(")")) {
                filterBuilder.append(")");
            }
            filterBuilder.append(activeFilter);
            filterBuilder.append(")");
            providersFilter = filterBuilder.toString();
        }
        boolean bl = filter == null ? false : (addBridge = filter.indexOf("admin.bridge.value") > -1);
        boolean bl2 = filter == null ? false : (addIcon = filter.indexOf("admin.icon.value") > -1);
        boolean bl3 = filter == null ? false : (addFriendlyName = filter.indexOf("admin.friendlyName.value") > -1);
        final boolean addLocation = filter == null ? false : filter.indexOf("admin.location.value") > -1;
        final boolean rawList = !resolveServices && !addBridge && !addIcon && !addFriendlyName && !addLocation;
        String namespace = this.namespace();
        final String prefix = !"#LOCAL#".equals(namespace) && sessionKey.localID() != 0 ? namespace.concat(":") : "";
        final AccessTree<? extends AccessNode> tree = sessionKey.getAccessTree();
        final AccessNode root = sessionKey.getAccessTree().getRoot();
        Set<String> serviceProviders = AccessController.doPrivileged(new PrivilegedAction<Set<String>>(){

            @Override
            public Set<String> run() {
                Collection<ServiceReference<SensiNactResourceModel>> references = RegistryEndpoint.this.getReferences(sessionKey, providersFilter);
                Iterator<ServiceReference<SensiNactResourceModel>> iterator = references.iterator();
                HashSet<String> providers = new HashSet<String>();
                while (iterator.hasNext()) {
                    StringBuilder builder = new StringBuilder();
                    ServiceReference<SensiNactResourceModel> ref = iterator.next();
                    AccessMethod.Type describe = AccessMethod.Type.valueOf(AccessMethod.DESCRIBE);
                    AccessMethod.Type get = AccessMethod.Type.valueOf(AccessMethod.GET);
                    String name = (String)ref.getProperty("name");
                    String provider = prefix + name;
                    if (!rawList) {
                        builder.append('{');
                        builder.append("\"name\":");
                    }
                    builder.append('\"');
                    builder.append(provider);
                    builder.append('\"');
                    if (!rawList) {
                        String resourceUri;
                        AccessNode node;
                        String location = null;
                        Object obj = ref.getProperty(ModelInstance.LOCATION_PROPERTY.concat(".value"));
                        location = obj == null || "null".equals(String.valueOf(obj)) ? RegistryEndpoint.this.defaultLocation : String.valueOf(obj).replace('\"', '\'');
                        Integer locationGetLevel = (Integer)ref.getProperty(ModelInstance.LOCATION_PROPERTY.concat(".GET"));
                        if (locationGetLevel == null) {
                            locationGetLevel = AccessLevelOption.OWNER.getAccessLevel().getLevel();
                        }
                        if ((node = root.get(resourceUri = UriUtils.getUri((String[])new String[]{name, "admin", "location"}))) == null) {
                            node = tree.getRoot();
                        }
                        int locationAccessLevel = node.getAccessLevelOption(get).getAccessLevel().getLevel();
                        obj = ref.getProperty(ModelInstance.FRIENDLY_NAME_PROPERTY.concat(".value"));
                        String friendlyName = obj == null || "null".equals(String.valueOf(obj)) ? null : String.valueOf(obj).replace('\"', '\'');
                        Integer friendlyNameGetLevel = (Integer)ref.getProperty(ModelInstance.FRIENDLY_NAME_PROPERTY.concat(".GET"));
                        if (friendlyNameGetLevel == null) {
                            friendlyNameGetLevel = AccessLevelOption.OWNER.getAccessLevel().getLevel();
                        }
                        if ((node = root.get(resourceUri = UriUtils.getUri((String[])new String[]{name, "admin", "friendlyName"}))) == null) {
                            node = tree.getRoot();
                        }
                        int friendlyNameAccessLevel = node.getAccessLevelOption(get).getAccessLevel().getLevel();
                        obj = ref.getProperty(ModelInstance.BRIDGE_PROPERTY.concat(".value"));
                        String bridge = obj == null || "null".equals(String.valueOf(obj)) ? null : String.valueOf(obj).replace('\"', '\'');
                        Integer bridgeGetLevel = (Integer)ref.getProperty(ModelInstance.BRIDGE_PROPERTY.concat(".GET"));
                        if (bridgeGetLevel == null) {
                            bridgeGetLevel = AccessLevelOption.OWNER.getAccessLevel().getLevel();
                        }
                        if ((node = root.get(resourceUri = UriUtils.getUri((String[])new String[]{name, "admin", "bridge"}))) == null) {
                            node = tree.getRoot();
                        }
                        int bridgeAccessLevel = node.getAccessLevelOption(get).getAccessLevel().getLevel();
                        obj = ref.getProperty(ModelInstance.ICON_PROPERTY.concat(".value"));
                        String icon = obj == null || "null".equals(String.valueOf(obj)) ? null : String.valueOf(obj).replace('\"', '\'');
                        Integer iconGetLevel = (Integer)ref.getProperty(ModelInstance.ICON_PROPERTY.concat(".GET"));
                        if (iconGetLevel == null) {
                            iconGetLevel = AccessLevelOption.OWNER.getAccessLevel().getLevel();
                        }
                        if ((node = root.get(resourceUri = UriUtils.getUri((String[])new String[]{name, "admin", "icon"}))) == null) {
                            node = tree.getRoot();
                        }
                        int iconAccessLevel = node.getAccessLevelOption(get).getAccessLevel().getLevel();
                        if (addLocation && locationAccessLevel >= locationGetLevel) {
                            builder.append(",\"location\":");
                            if (location != null) {
                                builder.append('\"');
                            }
                            builder.append(location);
                            if (location != null) {
                                builder.append('\"');
                            }
                        }
                        if (addBridge && bridgeAccessLevel >= bridgeGetLevel) {
                            builder.append(",\"bridge\":");
                            if (bridge != null) {
                                builder.append('\"');
                            }
                            builder.append(bridge);
                            if (bridge != null) {
                                builder.append('\"');
                            }
                        }
                        if (addIcon && iconAccessLevel >= iconGetLevel) {
                            builder.append(",\"icon\":");
                            if (icon != null) {
                                builder.append('\"');
                            }
                            builder.append(icon);
                            if (icon != null) {
                                builder.append('\"');
                            }
                        }
                        if (addFriendlyName && friendlyNameAccessLevel >= friendlyNameGetLevel) {
                            builder.append(",\"friendlyName\":");
                            if (friendlyName != null) {
                                builder.append('\"');
                            }
                            builder.append(friendlyName);
                            if (friendlyName != null) {
                                builder.append('\"');
                            }
                        }
                    }
                    if (!rawList && resolveServices) {
                        int slength;
                        List serviceList = (List)ref.getProperty("services");
                        builder.append(",\"services\":");
                        builder.append('[');
                        int pos = 0;
                        int n = slength = serviceList == null ? 0 : serviceList.size();
                        for (int sindex = 0; sindex < slength; ++sindex) {
                            int describeAccessLevel;
                            AccessNode node;
                            String service = (String)serviceList.get(sindex);
                            String serviceUri = UriUtils.getUri((String[])new String[]{name, service});
                            Integer serviceLevel = (Integer)ref.getProperty(service.concat(".DESCRIBE"));
                            if (serviceLevel == null) {
                                serviceLevel = AccessLevelOption.OWNER.getAccessLevel().getLevel();
                            }
                            if ((node = root.get(serviceUri)) == null) {
                                node = tree.getRoot();
                            }
                            if ((describeAccessLevel = node.getAccessLevelOption(describe).getAccessLevel().getLevel()) < serviceLevel) continue;
                            builder.append(pos > 0 ? Character.valueOf(',') : "");
                            builder.append('\"');
                            builder.append(service);
                            builder.append('\"');
                            ++pos;
                        }
                        builder.append(']');
                    }
                    if (!rawList) {
                        builder.append('}');
                    }
                    providers.add(builder.toString());
                }
                return providers;
            }
        });
        return serviceProviders.stream().collect(StringBuilder::new, (sb, s) -> {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append((String)s);
        }, StringBuilder::append).toString();
    }

    public String getProviders(SessionKey sessionKey, boolean resolveNamespace, String filter) {
        return this.getProviders(sessionKey, resolveNamespace, false, filter);
    }

    public String getProvider(SessionKey sessionKey, boolean resolveNamespace, String serviceProviderName, String filter) {
        String providersFilter = null;
        String effectiveFilter = "(name=" + serviceProviderName + ")";
        if (filter == null) {
            providersFilter = effectiveFilter;
        }
        if (filter != null) {
            StringBuilder filterBuilder = new StringBuilder().append("(&");
            if (!filter.startsWith("(")) {
                filterBuilder.append("(");
            }
            filterBuilder.append(filter);
            if (!filter.endsWith(")")) {
                filterBuilder.append(")");
            }
            filterBuilder.append(effectiveFilter);
            filterBuilder.append(")");
            providersFilter = filterBuilder.toString();
        }
        return this.getProviders(sessionKey, resolveNamespace, true, providersFilter);
    }

    public String getProvider(SessionKey sessionKey, boolean resolveNamespace, String serviceProviderName) {
        return this.getProvider(sessionKey, resolveNamespace, serviceProviderName, null);
    }

    public String getProvider(SessionKey sessionKey, String serviceProviderName) {
        return this.getProvider(sessionKey, false, serviceProviderName, null);
    }

    public Set<ServiceProvider> serviceProviders(final SessionKey sessionKey, String filter) {
        String activeFilter = "(lifecycle.status=ACTIVE)";
        String providersFilter = null;
        if (filter == null) {
            providersFilter = activeFilter;
        } else {
            StringBuilder filterBuilder = new StringBuilder().append("(&");
            if (!filter.startsWith("(")) {
                filterBuilder.append("(");
            }
            filterBuilder.append(filter);
            if (!filter.endsWith(")")) {
                filterBuilder.append(")");
            }
            filterBuilder.append(activeFilter);
            filterBuilder.append(")");
            providersFilter = filterBuilder.toString();
        }
        final String fltr = providersFilter;
        Set<ServiceProvider> serviceProviders = AccessController.doPrivileged(new PrivilegedAction<Set<ServiceProvider>>(){

            @Override
            public Set<ServiceProvider> run() {
                Collection<ServiceReference<SensiNactResourceModel>> references = RegistryEndpoint.this.getReferences(sessionKey, fltr);
                Iterator<ServiceReference<SensiNactResourceModel>> iterator = references.iterator();
                HashSet<ServiceProvider> providers = new HashSet<ServiceProvider>();
                while (iterator.hasNext()) {
                    ServiceReference<SensiNactResourceModel> ref = iterator.next();
                    SensiNactResourceModel model = (SensiNactResourceModel)RegistryEndpoint.this.mediator.getContext().getService(ref);
                    ServiceProvider provider = null;
                    try {
                        provider = (ServiceProvider)model.getRootElement().getProxy(sessionKey.getAccessTree());
                    }
                    catch (ModelElementProxyBuildException e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                    if (provider == null || !provider.isAccessible()) continue;
                    providers.add(provider);
                }
                return providers;
            }
        });
        return serviceProviders;
    }

    public ServiceProvider serviceProvider(SessionKey sessionKey, String serviceProviderName, String filter) {
        String providersFilter = null;
        String effectiveFilter = "(name=" + serviceProviderName + ")";
        if (filter == null) {
            providersFilter = effectiveFilter;
        }
        if (filter != null) {
            StringBuilder filterBuilder = new StringBuilder().append("(&");
            if (!filter.startsWith("(")) {
                filterBuilder.append("(");
            }
            filterBuilder.append(filter);
            if (!filter.endsWith(")")) {
                filterBuilder.append(")");
            }
            filterBuilder.append(effectiveFilter);
            filterBuilder.append(")");
            providersFilter = filterBuilder.toString();
        }
        ServiceProvider provider = null;
        Set<ServiceProvider> providers = this.serviceProviders(sessionKey, providersFilter);
        if (providers == null || providers.size() != 1) {
            return provider;
        }
        provider = providers.iterator().next();
        return provider;
    }

    public ServiceProvider serviceProvider(SessionKey sessionKey, String serviceProviderName) {
        return this.serviceProvider(sessionKey, serviceProviderName, null);
    }

    public Service service(SessionKey sessionKey, String serviceProviderName, String serviceName) {
        ServiceProvider serviceProvider = this.serviceProvider(sessionKey, serviceProviderName);
        Service service = null;
        if (serviceProvider != null) {
            service = serviceProvider.getService(serviceName);
        }
        return service;
    }

    public Resource resource(SessionKey sessionKey, String serviceProviderName, String serviceName, String resourceName) {
        Service service = this.service(sessionKey, serviceProviderName, serviceName);
        Resource resource = null;
        if (service != null) {
            resource = service.getResource(resourceName);
        }
        return resource;
    }

    public boolean isAccessible(AccessTree<? extends AccessNode> tree, String path) {
        String[] uriElements = UriUtils.getUriElements((String)path);
        String providerName = uriElements[0];
        String serviceName = uriElements.length > 1 ? uriElements[1] : null;
        String resourceName = uriElements.length > 2 ? uriElements[2] : null;
        String filter = "(&(name=" + providerName + ")(lifecycle.status=ACTIVE))";
        Collection<ServiceReference<SensiNactResourceModel>> references = this.getReferences(tree, filter);
        if (references.size() != 1) {
            return false;
        }
        ServiceReference<SensiNactResourceModel> reference = references.iterator().next();
        AccessMethod.Type describe = AccessMethod.Type.valueOf(AccessMethod.DESCRIBE);
        AccessNode node = tree.getRoot();
        int index = 0;
        String pa = null;
        String key = null;
        Integer inheritedObjectDescribeLevel = AccessLevelOption.OWNER.getAccessLevel().getLevel();
        do {
            switch (index) {
                case 0: {
                    pa = UriUtils.getUri((String[])new String[]{providerName});
                    key = providerName.concat(".DESCRIBE");
                    break;
                }
                case 1: {
                    List services = (List)reference.getProperty("services");
                    if (services == null || !services.contains(serviceName)) {
                        return false;
                    }
                    pa = UriUtils.getUri((String[])new String[]{pa, serviceName});
                    key = serviceName + ".DESCRIBE";
                    break;
                }
                case 2: {
                    List resources = (List)reference.getProperty(serviceName.concat(".resources"));
                    if (resources == null || !resources.contains(resourceName)) {
                        return false;
                    }
                    pa = UriUtils.getUri((String[])new String[]{pa, resourceName});
                    key = serviceName + "." + resourceName + ".DESCRIBE";
                    break;
                }
                default: {
                    return false;
                }
            }
            AccessNode tmpNode = tree.getRoot().get(pa);
            if (tmpNode == null) {
                tmpNode = node;
            } else {
                node = tmpNode;
            }
            Integer level = (Integer)reference.getProperty(key);
            if (level == null) {
                level = inheritedObjectDescribeLevel;
            } else {
                inheritedObjectDescribeLevel = level;
            }
            if (node.getAccessLevelOption(describe).getAccessLevel().getLevel() >= inheritedObjectDescribeLevel) continue;
            return false;
        } while (++index != uriElements.length);
        return true;
    }

    protected String namespace() {
        String namespace = (String)this.mediator.callService(SensinactCoreBaseIFaceManager.class, (Executable)new Executable<SensinactCoreBaseIFaceManager, String>(){

            public String execute(SensinactCoreBaseIFaceManager sensinactCoreBaseIFaceManager) throws Exception {
                return sensinactCoreBaseIFaceManager.namespace();
            }
        });
        return namespace == null ? "#LOCAL#" : namespace;
    }
}

