/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.sensinact.gateway.common.primitive.Nameable;
import org.eclipse.sensinact.gateway.core.AttributeBuilder;
import org.eclipse.sensinact.gateway.core.RequirementBuilder;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.StringPatternValue;
import org.eclipse.sensinact.gateway.core.TypeConfig;

public class ResourceConfig
implements Nameable {
    public static final String ALL_TARGETS = "#ANY_TARGET#";
    public static final String ALL_PROFILES = "#ANY_PROFILE#";
    protected List<String> profiles;
    protected List<String> targets;
    protected TypeConfig typeConfig;
    protected List<RequirementBuilder> requirementBuilders = new ArrayList<RequirementBuilder>();
    protected Resource.UpdatePolicy updatePolicy;

    public String buildName(String service) {
        if (service == null || service.length() == 0) {
            return null;
        }
        return this.requirementBuilders.stream().filter(rb -> "name".equals(rb.getName())).map(rb -> rb.get(service)).map(StringPatternValue.class::cast).map(StringPatternValue::build).findFirst().orElse(null);
    }

    public String getName() {
        return this.getName(ALL_TARGETS);
    }

    public String getName(String service) {
        if (service == null || service.length() == 0) {
            return this.getName(ALL_TARGETS);
        }
        return this.requirementBuilders.stream().filter(rb -> "name".equals(rb.getName())).map(rb -> rb.get(service)).map(StringPatternValue.class::cast).map(StringPatternValue::getLast).findFirst().orElse(null);
    }

    public String getRawName() {
        return this.getRawName(ALL_TARGETS);
    }

    public String getRawName(String serviceName) {
        if (serviceName == null || serviceName.length() == 0) {
            return this.getRawName(ALL_TARGETS);
        }
        return this.requirementBuilders.stream().filter(rb -> "name".equals(rb.getName())).map(rb -> rb.get(serviceName)).map(StringPatternValue.class::cast).map(StringPatternValue::getRaw).findFirst().orElse(null);
    }

    public void configureName(String service, String name) {
        Optional<RequirementBuilder> found = this.requirementBuilders.stream().filter(rb -> "name".equals(rb.getName())).findFirst();
        if (found.isPresent()) {
            found.get().put(service, name);
        } else {
            RequirementBuilder builder = new RequirementBuilder(AttributeBuilder.Requirement.VALUE, "name");
            builder.put(service, name);
            this.requirementBuilders.add(builder);
        }
    }

    public TypeConfig getTypeConfig() {
        return this.typeConfig;
    }

    public void setTypeConfig(TypeConfig typeConfig) {
        this.typeConfig = typeConfig;
    }

    public void setUpdatePolicy(Resource.UpdatePolicy updatePolicy) {
        this.updatePolicy = updatePolicy;
    }

    public Resource.UpdatePolicy getUpdatePolicy() {
        if (this.updatePolicy == null) {
            return Resource.UpdatePolicy.NONE;
        }
        return this.updatePolicy;
    }

    public boolean isTargeted(String serviceId) {
        if (serviceId == null || serviceId.length() == 0) {
            return this.isTargeted(ALL_TARGETS);
        }
        if (this.targets == null || this.targets.size() == 0) {
            return !serviceId.equals("admin");
        }
        return this.targets.indexOf(serviceId) > -1 || this.targets.indexOf(ALL_TARGETS) > -1 && !"admin".equals(serviceId);
    }

    public void setTarget(String target) {
        if (target == null) {
            return;
        }
        this.targets = Arrays.asList(target.split(","));
    }

    public boolean isProfiled(String profileId) {
        if (profileId == null) {
            return this.isProfiled(ALL_PROFILES);
        }
        if (this.profiles == null) {
            return ALL_PROFILES.equals(profileId);
        }
        return this.profiles.indexOf(profileId) > -1 || this.profiles.indexOf(ALL_PROFILES) > -1;
    }

    public void setProfile(String profile) {
        if (profile == null) {
            return;
        }
        this.profiles = Arrays.asList(profile.split(","));
    }

    public void addRequirementBuilder(RequirementBuilder requirementBuilder) {
        if (requirementBuilder == null) {
            return;
        }
        int index = -1;
        RequirementBuilder builder = null;
        index = this.requirementBuilders.indexOf(requirementBuilder);
        if (index > -1) {
            builder = this.requirementBuilders.get(index);
            for (Map.Entry<String, Object> entry : requirementBuilder) {
                builder.put(entry.getKey(), entry.getValue());
            }
        } else {
            this.requirementBuilders.add(requirementBuilder);
        }
    }

    public List<AttributeBuilder> getAttributeBuilders(String service) {
        List<AttributeBuilder> builders = this.typeConfig.getAttributeBuilders();
        Iterator<RequirementBuilder> iterator = this.requirementBuilders.iterator();
        while (iterator.hasNext()) {
            iterator.next().apply(service, builders);
        }
        return builders;
    }

    public List<String> getObserveds(String service) {
        return Collections.emptyList();
    }
}

