/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.filtering;

import java.util.ArrayList;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.filtering.FilteringAccessor;
import org.eclipse.sensinact.gateway.core.filtering.FilteringDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteringCollection {
    private static final Logger LOG = LoggerFactory.getLogger(FilteringAccessor.class);
    private Iterable<FilteringAccessor> accessors;
    private boolean hideFilter;
    private String filterJsonDefinition;

    public FilteringCollection(Mediator mediator, boolean hideFilter, FilteringDefinition ... filterDefinition) {
        int index;
        if (filterDefinition == null || filterDefinition.length == 0) {
            this.hideFilter = true;
            this.accessors = null;
            return;
        }
        int length = filterDefinition.length;
        StringBuilder jsonFormatedFilterBuilder = new StringBuilder();
        jsonFormatedFilterBuilder.append("[");
        ArrayList<FilteringAccessor> accessors = new ArrayList<FilteringAccessor>();
        int pos = 0;
        for (index = 0; index < length; ++index) {
            try {
                accessors.add(new FilteringAccessor(mediator, filterDefinition[index]));
                if (pos > 0) {
                    jsonFormatedFilterBuilder.append(",");
                }
                jsonFormatedFilterBuilder.append(String.format("{\"type\":\"%s\",\"definition\":\"%s\"}", filterDefinition[index].type, filterDefinition[index].filter));
                ++pos;
                continue;
            }
            catch (RuntimeException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        if (index != length) {
            this.filterJsonDefinition = "[]";
            this.hideFilter = true;
            this.accessors = null;
            return;
        }
        jsonFormatedFilterBuilder.append("]");
        this.filterJsonDefinition = jsonFormatedFilterBuilder.toString();
        this.accessors = accessors;
    }

    public String composeLDAPFormatedFilter(String ldapFilter) {
        String ldap = null;
        int index = 0;
        StringBuilder ldapFormatedFilterBuilder = new StringBuilder();
        if (ldapFilter != null) {
            ldap = ldapFilter.trim();
            if (!ldap.startsWith("(")) {
                ldapFormatedFilterBuilder.append("(");
            }
            ldapFormatedFilterBuilder.append(ldap);
            if (!ldap.endsWith(")")) {
                ldapFormatedFilterBuilder.append(")");
            }
            ++index;
        }
        if (this.accessors == null) {
            this.hideFilter = true;
            return ldapFormatedFilterBuilder.toString();
        }
        for (FilteringAccessor filteringAccessor : this.accessors) {
            ldap = filteringAccessor.getLDAPComponent();
            if (ldap == null || (ldap = ldap.trim()).length() == 0) continue;
            if (!ldap.startsWith("(")) {
                ldapFormatedFilterBuilder.append("(");
            }
            ldapFormatedFilterBuilder.append(ldap);
            if (!ldap.endsWith(")")) {
                ldapFormatedFilterBuilder.append(")");
            }
            if (index > 0) {
                ldapFormatedFilterBuilder.insert(0, "(&");
                ldapFormatedFilterBuilder.append(")");
            }
            ++index;
        }
        return ldapFormatedFilterBuilder.toString();
    }

    public String apply(String value) {
        String result = value;
        if (this.accessors != null) {
            for (FilteringAccessor filtering : this.accessors) {
                result = filtering.apply(result);
            }
        }
        return result;
    }

    public boolean hideFilter() {
        return this.hideFilter;
    }

    public String filterJsonDefinition() {
        return this.filterJsonDefinition;
    }
}

