/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.method.AbstractAccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethodExecutor;
import org.eclipse.sensinact.gateway.core.method.DescribeJSONResponseBuilder;
import org.eclipse.sensinact.gateway.core.method.DescribeResponse;
import org.eclipse.sensinact.gateway.core.method.DescribeResponseBuilder;
import org.eclipse.sensinact.gateway.core.method.DescribeStringResponseBuilder;

public class DescribeMethod<T>
extends AbstractAccessMethod<T, DescribeResponse<T>> {
    private DescribeType describeType;

    public DescribeMethod(Mediator mediator, String uri, AccessMethodExecutor preProcessingExecutor, DescribeType describeType) {
        super(mediator, uri, AccessMethod.DESCRIBE, preProcessingExecutor);
        this.describeType = describeType;
    }

    @Override
    public DescribeResponseBuilder<T> createAccessMethodResponseBuilder(Object[] parameters) {
        switch (this.describeType) {
            case FILTER_LIST: 
            case COMPLETE_LIST: 
            case PROVIDERS_LIST: 
            case RESOURCES_LIST: 
            case SERVICES_LIST: {
                return new DescribeStringResponseBuilder(this.mediator, this.uri, this.describeType, null);
            }
            case PROVIDER: 
            case SERVICE: 
            case RESOURCE: {
                return new DescribeJSONResponseBuilder(this.mediator, this.uri, this.describeType);
            }
        }
        return null;
    }

    public static enum DescribeType {
        FILTER_LIST("FILTER_LIST", "namespaces"),
        COMPLETE_LIST("COMPLETE_LIST", "providers"),
        PROVIDERS_LIST("PROVIDERS_LIST", "providers"),
        PROVIDER("DESCRIBE_PROVIDER", "response"),
        SERVICES_LIST("SERVICES_LIST", "services"),
        SERVICE("DESCRIBE_SERVICE", "response"),
        RESOURCES_LIST("RESOURCES_LIST", "resources"),
        RESOURCE("DESCRIBE_RESOURCE", "response");

        final String typeName;
        final String responseKey;

        private DescribeType(String typeName, String responseKey) {
            this.typeName = typeName;
            this.responseKey = responseKey;
        }

        String getTypeName() {
            return this.typeName;
        }

        String getResponseKey() {
            return this.responseKey;
        }
    }
}

