/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.remote;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.Sessions;
import org.eclipse.sensinact.gateway.core.message.Recipient;
import org.eclipse.sensinact.gateway.core.remote.RemoteCore;
import org.eclipse.sensinact.gateway.core.remote.RemoteEndpoint;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteEndpoint
implements RemoteEndpoint,
Sessions.SessionObserver {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRemoteEndpoint.class);
    private final Object lock = new Object();
    private volatile boolean connected;
    protected final boolean automaticReconnection;
    protected final Mediator mediator;
    protected RemoteCore remoteCore;
    protected Map<String, Recipient> recipients;
    private ConnectionThread connectionThread;

    protected abstract JSONObject doSubscribe(String var1, String var2, String var3, String var4, JSONArray var5);

    protected abstract void closeSession(String var1);

    protected abstract void doOpen();

    protected abstract void doClose();

    public AbstractRemoteEndpoint(Mediator mediator) {
        this(mediator, true);
    }

    public AbstractRemoteEndpoint(Mediator mediator, boolean automaticReconnection) {
        this.mediator = mediator;
        this.recipients = new HashMap<String, Recipient>();
        this.connected = false;
        this.connectionThread = null;
        this.automaticReconnection = automaticReconnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getConnected() {
        boolean connected = false;
        Object object = this.lock;
        synchronized (object) {
            connected = this.connected;
        }
        return connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConnected(boolean connected) {
        Object object = this.lock;
        synchronized (object) {
            this.connected = connected;
        }
    }

    @Override
    public void open(RemoteCore remoteCore) {
        if (this.getConnected()) {
            LOG.debug("Endpoint already connected");
            return;
        }
        this.remoteCore = remoteCore;
        if (this.automaticReconnection && (this.connectionThread == null || !this.connectionThread.running)) {
            this.connectionThread = new ConnectionThread();
            new Thread(this.connectionThread).start();
        } else {
            this.doOpen();
        }
    }

    protected void connected() {
        this.setConnected(true);
        this.remoteCore.connect(this.namespace());
    }

    @Override
    public void close() {
        if (this.connectionThread != null) {
            this.connectionThread.stop();
        }
        this.doClose();
        this.setConnected(false);
    }

    protected void disconnected() {
        if (!this.getConnected()) {
            return;
        }
        this.setConnected(false);
        this.remoteCore.disconnect();
    }

    @Override
    public JSONObject subscribe(String publicKey, String serviceProviderId, String serviceId, String resourceId, Recipient recipient, JSONArray conditions) {
        if (!this.getConnected()) {
            return null;
        }
        JSONObject response = this.doSubscribe(publicKey, serviceProviderId, serviceId, resourceId, conditions);
        try {
            this.recipients.put(response.getJSONObject("response").getString("subscriptionId"), recipient);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public String getLocalNamespace() {
        if (this.remoteCore == null) {
            return null;
        }
        return this.remoteCore.namespace();
    }

    @Override
    public void disappearing(String publicKey) {
        if (!this.getConnected()) {
            return;
        }
        this.closeSession(publicKey);
    }

    class ConnectionThread
    implements Runnable {
        boolean running = false;

        ConnectionThread() {
        }

        void stop() {
            this.running = false;
        }

        @Override
        public void run() {
            this.running = true;
            while (this.running) {
                boolean connected = AbstractRemoteEndpoint.this.getConnected();
                if (!connected) {
                    AbstractRemoteEndpoint.this.doOpen();
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    break;
                }
            }
        }
    }
}

