/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.sensinact.gateway.common.bundle.AbstractActivator;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.ModelConfiguration;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModelConfiguration;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.ServiceProviderImpl;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtModelConfigurationBuilder;
import org.eclipse.sensinact.gateway.generic.ExtResourceImpl;
import org.eclipse.sensinact.gateway.generic.ExtServiceImpl;
import org.eclipse.sensinact.gateway.generic.ExtServiceProviderImpl;
import org.eclipse.sensinact.gateway.generic.ProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.generic.annotation.SensiNactBridgeConfiguration;
import org.eclipse.sensinact.gateway.generic.annotation.ServiceProviderDefinition;
import org.eclipse.sensinact.gateway.generic.local.LocalProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.util.ReflectUtils;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasisActivator<P extends Packet>
extends AbstractActivator<Mediator> {
    private static final Logger LOG = LoggerFactory.getLogger(BasisActivator.class);
    private static final SensiNactBridgeConfiguration DEFAULT_SENSINACT_BRIDGE_CONFIGURATION = new SensiNactBridgeConfiguration(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return SensiNactBridgeConfiguration.class;
        }

        @Override
        public String resourceDefinition() {
            return "resources.xml";
        }

        @Override
        public SensiNactResourceModelConfiguration.BuildPolicy[] serviceBuildPolicy() {
            return new SensiNactResourceModelConfiguration.BuildPolicy[]{SensiNactResourceModelConfiguration.BuildPolicy.BUILD_COMPLETE_ON_DESCRIPTION};
        }

        @Override
        public SensiNactResourceModelConfiguration.BuildPolicy[] resourceBuildPolicy() {
            return new SensiNactResourceModelConfiguration.BuildPolicy[]{SensiNactResourceModelConfiguration.BuildPolicy.BUILD_COMPLETE_ON_DESCRIPTION};
        }

        @Override
        public boolean startAtInitializationTime() {
            return true;
        }

        @Override
        public Class<? extends Packet> packetType() {
            return Packet.class;
        }

        @Override
        public Class<? extends ProtocolStackEndpoint> endpointType() {
            return LocalProtocolStackEndpoint.class;
        }

        @Override
        public ServiceProviderDefinition[] initialProviders() {
            return new ServiceProviderDefinition[0];
        }

        @Override
        public String[] observed() {
            return new String[0];
        }

        @Override
        public boolean outputOnly() {
            return false;
        }

        @Override
        public Class<? extends ServiceProviderImpl> serviceProviderType() {
            return ExtServiceProviderImpl.class;
        }

        @Override
        public Class<? extends ServiceImpl> serviceType() {
            return ExtServiceImpl.class;
        }

        @Override
        public Class<? extends ResourceImpl> resourceType() {
            return ExtResourceImpl.class;
        }
    };
    protected ProtocolStackEndpoint<P> endpoint;

    public void doStart() throws Exception {
        Class packetType;
        Class clazz;
        SensiNactBridgeConfiguration activation = ((Object)((Object)this)).getClass().getAnnotation(SensiNactBridgeConfiguration.class);
        if (activation == null) {
            activation = DEFAULT_SENSINACT_BRIDGE_CONFIGURATION;
        }
        if ((clazz = activation.packetType()) == null) {
            throw new NullPointerException("No valid packet type defined");
        }
        if (clazz == Packet.class && !activation.outputOnly()) {
            try {
                packetType = (Class)((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            }
            catch (ClassCastException | TypeNotPresentException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new NullPointerException("No valid packet type defined");
            }
        } else {
            packetType = clazz;
        }
        byte serviceBuildPolicy = 0;
        for (SensiNactResourceModelConfiguration.BuildPolicy policy : activation.serviceBuildPolicy()) {
            serviceBuildPolicy = (byte)(serviceBuildPolicy | policy.getPolicy());
        }
        byte resourceBuildPolicy = 0;
        for (SensiNactResourceModelConfiguration.BuildPolicy policy : activation.resourceBuildPolicy()) {
            resourceBuildPolicy = (byte)(resourceBuildPolicy | policy.getPolicy());
        }
        Map<String, String> initialMap = Arrays.stream(activation.initialProviders()).collect(Collectors.toMap(p -> p.name(), p -> p.profileId()));
        Class<? extends ProtocolStackEndpoint> endpointType = activation.endpointType();
        ModelConfiguration configuration = ExtModelConfigurationBuilder.instance(this.mediator, packetType).withServiceBuildPolicy(serviceBuildPolicy).withResourceBuildPolicy(resourceBuildPolicy).withStartAtInitializationTime(activation.startAtInitializationTime()).withObserved(Arrays.asList(activation.observed())).withProviderImplementationType((Class)activation.serviceProviderType()).withServiceImplementationType((Class)activation.serviceType()).withResourceImplementationType((Class)activation.resourceType()).build(new Object[]{activation.resourceDefinition(), initialMap});
        this.endpoint = (ProtocolStackEndpoint)ReflectUtils.getInstance(ProtocolStackEndpoint.class, endpointType, (Object[])new Object[]{this.mediator});
        this.configure();
        this.endpoint.connect((ExtModelConfiguration<P>)configuration);
    }

    protected void configure() {
        LOG.debug("BasisActivator configuration ... done !");
    }

    public void doStop() throws Exception {
        if (this.endpoint != null) {
            this.endpoint.stop();
        }
    }

    public Mediator doInstantiate(BundleContext context) {
        return new Mediator(context);
    }
}

