/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.constraint.Fixed;
import org.eclipse.sensinact.gateway.common.primitive.JSONable;
import org.eclipse.sensinact.gateway.generic.parser.ConstrainableDefinition;
import org.eclipse.sensinact.gateway.generic.parser.ConstraintDefinition;
import org.eclipse.sensinact.gateway.generic.parser.ResolvedNameTypeValueDefinition;
import org.eclipse.sensinact.gateway.generic.parser.TypeDefinition;
import org.eclipse.sensinact.gateway.generic.parser.TypeValuePair;
import org.eclipse.sensinact.gateway.generic.parser.XmlEscaped;
import org.eclipse.sensinact.gateway.util.JSONUtils;
import org.xml.sax.Attributes;

@XmlEscaped(value={"constraints"})
public class ConditionalConstant
extends ResolvedNameTypeValueDefinition
implements ConstrainableDefinition,
JSONable {
    private List<ConstraintDefinition> constraints = new ArrayList<ConstraintDefinition>();

    public ConditionalConstant(Mediator mediator, Attributes atts) {
        super(mediator, atts);
    }

    @Override
    public void addConstraint(ConstraintDefinition constraint) {
        this.constraints.add(constraint);
    }

    public boolean isUnconditional() {
        int length = this.constraints.size();
        return length == 0 || length == 1 && Fixed.class.isAssignableFrom(this.constraints.get(0).getClass());
    }

    public String getJSON() {
        TypeValuePair pair = super.getTypeValuePair();
        String constant = JSONUtils.toJSONFormat((Object)pair.value);
        StringBuilder builder = new StringBuilder();
        if (this.isUnconditional()) {
            return constant;
        }
        builder.append('{');
        builder.append('\"');
        builder.append("constant");
        builder.append('\"');
        builder.append(':');
        builder.append(constant);
        builder.append(',');
        builder.append('\"');
        builder.append("constraint");
        builder.append('\"');
        builder.append(':');
        builder.append('[');
        for (int index = 0; index < this.constraints.size(); ++index) {
            builder.append(index > 0 ? Character.valueOf(',') : "");
            ConstraintDefinition def = this.constraints.get(index);
            def.setType(new TypeDefinition(pair.type));
            builder.append(def.getJSON());
        }
        builder.append(']');
        builder.append('}');
        return builder.toString();
    }
}

