/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.parser.ConstrainableDefinition;
import org.eclipse.sensinact.gateway.generic.parser.ConstraintDefinition;
import org.eclipse.sensinact.gateway.generic.parser.InvalidXmlDefinitionException;
import org.eclipse.sensinact.gateway.generic.parser.NameTypeValueDefinition;
import org.eclipse.sensinact.gateway.generic.parser.TypeValuePair;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class ResolvedNameTypeValueDefinition
extends NameTypeValueDefinition<Class<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(ResolvedNameTypeValueDefinition.class);

    ResolvedNameTypeValueDefinition(Mediator mediator, Attributes atts) {
        super(mediator, atts);
    }

    protected final TypeValuePair getTypeValuePair() {
        Class type = (Class)super.getType();
        return new TypeValuePair(type, this.valueDefinition != null ? this.valueDefinition.getValue() : null);
    }

    @Override
    public void setType(String type) {
        this.type = null;
        try {
            this.type = CastUtils.loadClass((ClassLoader)this.mediator.getClassLoader(), (String)type);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Invalid type : " + type);
        }
    }

    @Override
    public void setType(Class<?> type) {
        this.type = type;
    }

    public void minExclusiveStart(Attributes atts) throws InvalidXmlDefinitionException {
        this.startConstraint(atts, "minExclusive");
    }

    public void minInclusiveStart(Attributes atts) throws InvalidXmlDefinitionException {
        this.startConstraint(atts, "minInclusive");
    }

    public void maxExclusiveStart(Attributes atts) throws InvalidXmlDefinitionException {
        this.startConstraint(atts, "maxExclusive");
    }

    public void maxInclusiveStart(Attributes atts) throws InvalidXmlDefinitionException {
        this.startConstraint(atts, "maxInclusive");
    }

    public void lengthStart(Attributes atts) throws InvalidXmlDefinitionException {
        this.startConstraint(atts, "length");
    }

    public void minLengthStart(Attributes atts) throws InvalidXmlDefinitionException {
        this.startConstraint(atts, "minLength");
    }

    public void maxLengthStart(Attributes atts) throws InvalidXmlDefinitionException {
        this.startConstraint(atts, "maxLength");
    }

    public void enumerationStart(Attributes atts) throws InvalidXmlDefinitionException {
        this.startConstraint(atts, "enumeration");
    }

    public void fixedStart(Attributes atts) throws InvalidXmlDefinitionException {
        this.startConstraint(atts, "fixed");
    }

    public void patternStart(Attributes atts) throws InvalidXmlDefinitionException {
        this.startConstraint(atts, "pattern");
    }

    public void deltaStart(Attributes atts) throws InvalidXmlDefinitionException {
        this.startConstraint(atts, "delta");
    }

    public void absoluteStart(Attributes atts) throws InvalidXmlDefinitionException {
        this.startConstraint(atts, "absolute");
    }

    public void startConstraint(Attributes atts, String name) throws InvalidXmlDefinitionException {
        if (ConstrainableDefinition.class.isAssignableFrom(this.getClass())) {
            ConstraintDefinition constraintDefinition = new ConstraintDefinition(this.mediator, name, atts);
            constraintDefinition.setType(this.getTypeDefinition());
            ((ConstrainableDefinition)((Object)this)).addConstraint(constraintDefinition);
            this.setNext(constraintDefinition);
        }
    }
}

