/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.constraint;

import java.util.logging.Logger;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.eclipse.sensinact.gateway.util.JSONUtils;

public abstract class ConstraintOnComparable<T>
implements Constraint {
    protected static final Logger LOGGER = Logger.getLogger(ConstraintOnComparable.class.getCanonicalName());
    protected final String operator;
    protected Comparable<T> operand;
    protected final boolean complement;

    protected abstract boolean doComplies(T var1);

    public ConstraintOnComparable(String operator, Comparable<T> operand, boolean complement) {
        this.operator = operator;
        this.operand = operand;
        this.complement = complement;
    }

    public ConstraintOnComparable(String operator, Class<?> operandClass, Object operand, boolean complement) throws InvalidConstraintDefinitionException {
        this.operator = operator;
        Class comparableClass = operandClass;
        if (!Comparable.class.isAssignableFrom(comparableClass) && (comparableClass = CastUtils.primitiveToComparable(operandClass)) == null) {
            throw new InvalidConstraintDefinitionException(operand.getClass().getCanonicalName() + " cannot be casted to Comparable");
        }
        this.operand = (Comparable)CastUtils.cast((Class)comparableClass, (Object)operand);
        this.complement = complement;
    }

    @Override
    public boolean complies(Object value) {
        if (value == null) {
            return false;
        }
        Object castedValue = null;
        try {
            castedValue = CastUtils.cast(this.operand.getClass(), (Object)value);
        }
        catch (ClassCastException e) {
            return false;
        }
        return this.doComplies(castedValue);
    }

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public boolean isComplement() {
        return this.complement;
    }

    @Override
    public String getJSON() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        builder.append('\"');
        builder.append("operator");
        builder.append('\"');
        builder.append(':');
        builder.append('\"');
        builder.append(this.getOperator());
        builder.append('\"');
        builder.append(',');
        builder.append('\"');
        builder.append("type");
        builder.append('\"');
        builder.append(':');
        builder.append('\"');
        builder.append(CastUtils.writeClass(this.operand.getClass()));
        builder.append('\"');
        builder.append(',');
        builder.append('\"');
        builder.append("complement");
        builder.append('\"');
        builder.append(':');
        builder.append(this.isComplement());
        builder.append(',');
        builder.append('\"');
        builder.append("operand");
        builder.append('\"');
        builder.append(':');
        builder.append(JSONUtils.toJSONFormat(this.operand));
        builder.append('}');
        return builder.toString();
    }
}

